/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.mc;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.client.CutSceneManagement;
import com.storyanvil.cogwheel.client.screen.DialogChoiceScreen;
import com.storyanvil.cogwheel.client.screen.DialogMessageScreen;
import com.storyanvil.cogwheel.data.CameraPos;
import com.storyanvil.cogwheel.data.IStoryPacketContext;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryAnimator;
import com.storyanvil.cogwheel.network.mc.AnimationBound;
import com.storyanvil.cogwheel.network.mc.CameraForceBound;
import com.storyanvil.cogwheel.network.mc.CameraTransitionBound;
import com.storyanvil.cogwheel.network.mc.DialogBound;
import com.storyanvil.cogwheel.network.mc.DialogChoiceBound;
import com.storyanvil.cogwheel.util.Bi;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class CogwheelClientPacketHandler {
    public static void animationBound(AnimationBound animationBound, IStoryPacketContext ctx) {
        CogwheelExecutor.scheduleTickEventClientSide(level -> {
            int d;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                CogwheelExecutor.log.warn("Failed to run animation bound as LocalPlayer is NULL!");
                return;
            }
            BlockPos pos = new BlockPos(player.getBlockX(), player.getBlockY(), player.getBlockZ());
            AABB aabb = new AABB(pos.south(d = 1000).east(d).below(d).getCenter(), pos.north(d).west(d).above(d).getCenter());
            List e = level.getEntities((EntityTypeTest)new EntityTypeTest<Entity, Entity>(){

                @Nullable
                public Entity downcast(Entity obj) {
                    if (obj instanceof StoryAnimator) {
                        StoryAnimator animator = (StoryAnimator)obj;
                        return obj;
                    }
                    return null;
                }

                public Class<? extends Entity> getBaseClass() {
                    return Entity.class;
                }
            }, aabb, entity -> true);
            if (e.isEmpty()) {
                CogwheelExecutor.log.warn("Failed to run animation bound for {}->{} | No StoryAnimators found", (Object)animationBound.animatorID(), (Object)animationBound.animation());
                return;
            }
            for (Entity entity2 : e) {
                StoryAnimator animator = (StoryAnimator)entity2;
                animator.pushAnimation(animationBound.animation());
            }
        });
    }

    public static Object dialogChoiceBound(DialogChoiceBound bound, IStoryPacketContext ctx) {
        if (bound.close()) {
            Minecraft.getInstance().setScreen(null);
        } else {
            Minecraft.getInstance().setScreen((Screen)new DialogChoiceScreen(bound));
        }
        return null;
    }

    public static void dialogBound(DialogBound bound, IStoryPacketContext ctx) {
        if (bound.close()) {
            Minecraft.getInstance().setScreen(null);
        } else {
            Minecraft.getInstance().setScreen((Screen)new DialogMessageScreen(bound));
        }
    }

    public static void cameraForce(CameraForceBound cameraForceBound, IStoryPacketContext ctx) {
        CutSceneManagement.setPositionForce(cameraForceBound.pos());
    }

    public static void cameraTrans(CameraTransitionBound cameraTransitionBound, IStoryPacketContext ctx) {
        CutSceneManagement.setTransitionGoal(cameraTransitionBound.goal());
        CutSceneManagement.setTransition(new Bi<CameraPos, CameraPos>(cameraTransitionBound.pos1(), cameraTransitionBound.pos2()));
    }
}

