/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.storyanvil.cogwheel.api.Api;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoryUtils {
    @Api.Stable(since="2.0.0")
    public static void sendGlobalMessage(@NotNull ServerLevel level, Component msg) {
        for (ServerPlayer player : level.players()) {
            player.sendSystemMessage(msg);
        }
    }

    @Api.Stable(since="2.0.0")
    public static void sendGlobalMessage(@NotNull ServerLevel level, Component ... msg) {
        for (ServerPlayer player : level.players()) {
            for (Component c : msg) {
                player.sendSystemMessage(c);
            }
        }
    }

    @Api.Stable(since="2.0.0")
    public static void deleteDirectory(@NotNull File dir) {
        File[] childFiles;
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory() && (childFiles = dir.listFiles()) != null) {
            for (File f : childFiles) {
                StoryUtils.deleteDirectory(f);
            }
        }
        if (!dir.delete()) {
            throw new RuntimeException("Failed to delete: " + String.valueOf(dir));
        }
    }

    public static void discoverDirectory(@NotNull File file, @NotNull BiConsumer<File, String> consumer) {
        StoryUtils.discoverDirectory(file, consumer, "");
    }

    public static void discoverDirectory(@NotNull File file, @NotNull BiConsumer<File, String> consumer, @NotNull String path) {
        path = (String)path + "/" + file.getName();
        if (!file.isDirectory()) {
            consumer.accept(file, (String)path);
            return;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            StoryUtils.discoverDirectory(f, consumer, (String)path);
        }
    }

    @Api.Experimental(since="2.0.0")
    public static void unpackZip(File zip, File directory) throws IOException {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zip));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            File newFile = StoryUtils.newFile(directory, zipEntry);
            if (zipEntry.isDirectory()) {
                if (!newFile.isDirectory() && !newFile.mkdirs()) {
                    throw new IOException("Failed to create directory " + String.valueOf(newFile));
                }
            } else {
                int len;
                File parent = newFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directory " + String.valueOf(parent));
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    @NotNull
    private static File newFile(File destinationDir, @NotNull ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    @Api.Stable(since="2.6.0")
    public static boolean isHovering(int mouseX, int mouseY, int left, int right, int top, int bottom) {
        return mouseX >= left && mouseX <= right && mouseY >= top && mouseY <= bottom;
    }

    @Api.Stable(since="2.9.0")
    public static MutableComponent subText(MutableComponent source, int from, int to) {
        MutableComponent c = Component.empty();
        boolean l = false;
        AtomicInteger skip = new AtomicInteger(from);
        AtomicInteger left = new AtomicInteger(to - from - 1);
        source.visit((style, content) -> {
            int s = content.length();
            if (skip.get() > 0) {
                if (skip.get() >= s) {
                    skip.addAndGet(-s);
                } else {
                    c.append((Component)Component.literal((String)content.substring(skip.get())).withStyle(style));
                    skip.set(0);
                }
                return Optional.empty();
            }
            if (left.get() > 0) {
                int lef = left.get();
                if (lef > s) {
                    c.append((Component)Component.literal((String)content).withStyle(style));
                    left.addAndGet(-s);
                } else {
                    c.append((Component)Component.literal((String)content.substring(0, lef)).withStyle(style));
                    left.set(0);
                }
            }
            return Optional.empty();
        }, Style.EMPTY);
        return c;
    }

    @Api.Stable(since="2.10.1")
    public static JsonObject toCompoundJSON(CompoundTag tag) {
        JsonObject root = new JsonObject();
        for (String key : tag.getAllKeys()) {
            Tag t = tag.get(key);
            JsonElement e = StoryUtils.toElement(t);
            if (e == null) continue;
            root.add(key, e);
        }
        return root;
    }

    @Api.Stable(since="2.10.1")
    public static JsonArray toCompoundJSON(CollectionTag<?> tag) {
        JsonArray root = new JsonArray();
        for (int i = 0; i < root.size(); ++i) {
            JsonElement e = StoryUtils.toElement((Tag)tag.get(i));
            if (e == null) continue;
            root.add(e);
        }
        return root;
    }

    @Api.Stable(since="2.10.1")
    public static JsonElement toElement(Tag t) {
        if (t instanceof NumericTag) {
            if (t instanceof ShortTag) {
                ShortTag T = (ShortTag)t;
                return StoryUtils.toJSON(T);
            }
            if (t instanceof DoubleTag) {
                DoubleTag T = (DoubleTag)t;
                return StoryUtils.toJSON(T);
            }
            if (t instanceof FloatTag) {
                FloatTag T = (FloatTag)t;
                return StoryUtils.toJSON(T);
            }
            if (t instanceof ByteTag) {
                ByteTag T = (ByteTag)t;
                return StoryUtils.toJSON(T);
            }
            if (t instanceof IntTag) {
                IntTag T = (IntTag)t;
                return StoryUtils.toJSON(T);
            }
            if (t instanceof LongTag) {
                LongTag T = (LongTag)t;
                return StoryUtils.toJSON(T);
            }
        } else {
            if (t instanceof CompoundTag) {
                CompoundTag T = (CompoundTag)t;
                return StoryUtils.toCompoundJSON(T);
            }
            if (t instanceof CollectionTag) {
                CollectionTag T = (CollectionTag)t;
                return StoryUtils.toCompoundJSON(T);
            }
            if (t instanceof StringTag) {
                StringTag T = (StringTag)t;
                return StoryUtils.toJSON(T);
            }
        }
        return null;
    }

    @Api.Stable(since="2.10.1")
    public static JsonPrimitive toJSON(StringTag tag) {
        return new JsonPrimitive(tag.getAsString());
    }

    @Api.Stable(since="2.10.1")
    public static JsonPrimitive toJSON(ShortTag tag) {
        return new JsonPrimitive((Number)tag.getAsShort());
    }

    @Api.Stable(since="2.10.1")
    public static JsonPrimitive toJSON(DoubleTag tag) {
        return new JsonPrimitive((Number)tag.getAsDouble());
    }

    @Api.Stable(since="2.10.1")
    public static JsonPrimitive toJSON(FloatTag tag) {
        return new JsonPrimitive((Number)Float.valueOf(tag.getAsFloat()));
    }

    @Api.Stable(since="2.10.1")
    public static JsonPrimitive toJSON(ByteTag tag) {
        return new JsonPrimitive((Number)tag.getAsByte());
    }

    @Api.Stable(since="2.10.1")
    public static JsonPrimitive toJSON(IntTag tag) {
        return new JsonPrimitive((Number)tag.getAsInt());
    }

    @Api.Stable(since="2.10.1")
    public static JsonPrimitive toJSON(LongTag tag) {
        return new JsonPrimitive((Number)tag.getAsLong());
    }

    @Api.Stable(since="2.0.0")
    public static void encodeString(@NotNull FriendlyByteBuf buf, @Nullable String str) {
        if (str == null) {
            str = "";
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(bytes.length);
        buf.writeBytes(bytes);
    }

    @Contract(value="_ -> new")
    @Api.Stable(since="2.0.0")
    @NotNull
    public static String decodeString(@NotNull FriendlyByteBuf buf) {
        int length = buf.readInt();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = buf.readByte();
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

