/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.cog.CogBool;
import com.storyanvil.cogwheel.infrastructure.cog.CogEntity;
import com.storyanvil.cogwheel.infrastructure.cog.CogEventCallback;
import com.storyanvil.cogwheel.infrastructure.cog.CogInteger;
import com.storyanvil.cogwheel.infrastructure.cog.CogPlayer;
import com.storyanvil.cogwheel.infrastructure.cog.CogString;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.util.DataStorage;
import com.storyanvil.cogwheel.util.ScriptStorage;
import java.lang.ref.WeakReference;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="storyanvil_cogwheel")
@Api.Internal
@ApiStatus.Internal
public class ScriptEventBus {
    @SubscribeEvent
    @Api.Internal
    @ApiStatus.Internal
    public static void blockPlaced(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ScriptStorage storage = new ScriptStorage();
            CogEventCallback callback = new CogEventCallback();
            storage.put("internal_callback", callback);
            storage.put("event_player", new CogPlayer(new WeakReference<ServerPlayer>(player)));
            storage.put("event_x", new CogInteger(event.getPos().m_123341_()));
            storage.put("event_y", new CogInteger(event.getPos().m_123342_()));
            storage.put("event_z", new CogInteger(event.getPos().m_123343_()));
            storage.put("event_block", new CogString(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)event.getPlacedBlock().m_60734_())).toString()));
            CogScriptEnvironment.dispatchEventGlobal(ScriptEventBus.getEventLocation("block/placed"), storage);
            if (callback.isCanceled()) {
                event.setCanceled(true);
            }
        }
    }

    @Contract(value="_ -> new")
    @Api.Internal
    @ApiStatus.Internal
    @NotNull
    public static ResourceLocation getEventLocation(String loc) {
        return ResourceLocation.fromNamespaceAndPath((String)"storyanvil_cogwheel", (String)loc);
    }

    @SubscribeEvent
    @Api.Internal
    @ApiStatus.Internal
    public static void blockBroken(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ScriptStorage storage = new ScriptStorage();
            CogEventCallback callback = new CogEventCallback();
            storage.put("internal_callback", callback);
            storage.put("event_player", new CogPlayer(new WeakReference<ServerPlayer>(player2)));
            storage.put("event_x", new CogInteger(event.getPos().m_123341_()));
            storage.put("event_y", new CogInteger(event.getPos().m_123342_()));
            storage.put("event_z", new CogInteger(event.getPos().m_123343_()));
            storage.put("event_block", new CogString(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)event.getState().m_60734_())).toString()));
            CogScriptEnvironment.dispatchEventGlobal(ScriptEventBus.getEventLocation("block/broken"), storage);
            if (callback.isCanceled()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    @Api.Internal
    @ApiStatus.Internal
    public static void chatMessage(@NotNull ServerChatEvent event) {
        ScriptStorage storage = new ScriptStorage();
        CogEventCallback callback = new CogEventCallback();
        storage.put("internal_callback", callback);
        storage.put("event_player", new CogPlayer(new WeakReference<ServerPlayer>(event.getPlayer())));
        storage.put("event_message", new CogString(event.getRawText()));
        CogScriptEnvironment.dispatchEventGlobal(ScriptEventBus.getEventLocation("chat_msg"), storage);
        if (callback.isCanceled()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @Api.Internal
    @ApiStatus.Internal
    public static void blockRightClick(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerInteractEvent.RightClickBlock event) {
        if (event.getSide() == LogicalSide.CLIENT) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            long li;
            ServerPlayer player2 = (ServerPlayer)player;
            long ct = System.currentTimeMillis();
            if (ct - (li = Long.parseLong(DataStorage.getString((Entity)player2, "li", "0"))) <= 1000L) {
                return;
            }
            DataStorage.setString((Entity)player2, "li", String.valueOf(ct));
            ScriptStorage storage = new ScriptStorage();
            CogEventCallback callback = new CogEventCallback();
            storage.put("internal_callback", callback);
            storage.put("event_player", new CogPlayer(new WeakReference<ServerPlayer>(player2)));
            storage.put("event_x", new CogInteger(event.getPos().m_123341_()));
            storage.put("event_y", new CogInteger(event.getPos().m_123342_()));
            storage.put("event_z", new CogInteger(event.getPos().m_123343_()));
            CogScriptEnvironment.dispatchEventGlobal(ScriptEventBus.getEventLocation("block/use"), storage);
            if (callback.isCanceled()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    @Api.Internal
    @ApiStatus.Internal
    public static void entityRightClick(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerInteractEvent.EntityInteract event) {
        if (event.getSide() == LogicalSide.CLIENT) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ScriptStorage storage = new ScriptStorage();
            CogEventCallback callback = new CogEventCallback();
            storage.put("internal_callback", callback);
            storage.put("event_player", new CogPlayer(new WeakReference<ServerPlayer>(player2)));
            storage.put("event_x", new CogInteger(event.getPos().m_123341_()));
            storage.put("event_y", new CogInteger(event.getPos().m_123342_()));
            storage.put("event_z", new CogInteger(event.getPos().m_123343_()));
            storage.put("event_entity", new CogEntity(event.getTarget()));
            CogScriptEnvironment.dispatchEventGlobal(ScriptEventBus.getEventLocation("entity/use"), storage);
            if (callback.isCanceled()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    @Api.Internal
    @ApiStatus.Internal
    public static void playerRespawn(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ScriptStorage storage = new ScriptStorage();
            CogEventCallback callback = new CogEventCallback();
            storage.put("internal_callback", callback);
            storage.put("event_player", new CogPlayer(new WeakReference<ServerPlayer>(player2)));
            storage.put("event_endConquered", CogBool.getInstance(event.isEndConquered()));
            CogScriptEnvironment.dispatchEventGlobal(ScriptEventBus.getEventLocation("player/respawn"), storage);
            if (callback.isCanceled()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    @Api.Internal
    @ApiStatus.Internal
    public static void entityAttacked(@NotNull AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ScriptStorage storage = new ScriptStorage();
            CogEventCallback callback = new CogEventCallback();
            storage.put("internal_callback", callback);
            storage.put("event_player", new CogPlayer(new WeakReference<ServerPlayer>(player2)));
            storage.put("event_entity", new CogEntity(event.getTarget()));
            CogScriptEnvironment.dispatchEventGlobal(ScriptEventBus.getEventLocation("entity/attack"), storage);
            if (callback.isCanceled()) {
                event.setCanceled(true);
            }
        }
    }
}

