/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.api;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.client.saui.AbstractCogComponent;
import com.storyanvil.cogwheel.client.saui.SAUI;
import com.storyanvil.cogwheel.data.StoryCodec;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.cog.CogBool;
import com.storyanvil.cogwheel.infrastructure.cog.CogDouble;
import com.storyanvil.cogwheel.infrastructure.cog.CogEntity;
import com.storyanvil.cogwheel.infrastructure.cog.CogInteger;
import com.storyanvil.cogwheel.infrastructure.cog.CogLike;
import com.storyanvil.cogwheel.infrastructure.cog.CogLong;
import com.storyanvil.cogwheel.infrastructure.cog.CogPlayer;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.registry.CogwheelRegistries;
import com.storyanvil.cogwheel.util.ScriptLineHandler;
import com.storyanvil.cogwheel.util.ScriptStorage;
import java.lang.ref.WeakReference;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class CogwheelAPI {
    @Api.Stable(since="2.0.0")
    public static void fireEvent(ResourceLocation event, ScriptStorage storage) {
        CogScriptEnvironment.dispatchEventGlobal(event, storage);
    }

    @Api.Stable(since="2.0.0")
    public static void runScript(ResourceLocation rl) {
        CogScriptEnvironment.dispatchScriptGlobal(rl);
    }

    @Api.Stable(since="2.0.0")
    public static void runScript(ResourceLocation rl, ScriptStorage storage) {
        CogScriptEnvironment.dispatchScriptGlobal(rl, storage);
    }

    @Api.Stable(since="2.0.0")
    public static void registerScriptLineHandler(@NotNull ScriptLineHandler handler) {
        CogwheelRegistries.register(handler);
    }

    @Api.Stable(since="2.0.0")
    public static void registerDefaultScriptVariables(@NotNull String name, @NotNull Function<DispatchedScript, CogPropertyManager> f) {
        CogwheelRegistries.register(name, f);
    }

    @Api.Stable(since="2.8.0")
    public static void registerCogComponent(ResourceLocation loc, StoryCodec<AbstractCogComponent> codec) {
        SAUI.registerCogComponent(loc, codec);
    }

    @Api.Stable(since="2.8.0")
    public static CogBool cogify(boolean value) {
        return CogBool.getInstance(value);
    }

    @Api.Stable(since="2.8.0")
    public static CogBool cogify(Boolean value) {
        return value == null ? null : CogBool.getInstance(value);
    }

    @Api.Stable(since="2.8.0")
    public static CogInteger cogify(int value) {
        return new CogInteger(value);
    }

    @Api.Stable(since="2.8.0")
    public static CogInteger cogify(Integer value) {
        return value == null ? null : new CogInteger(value);
    }

    @Api.Stable(since="2.8.0")
    public static CogLong cogify(long value) {
        return new CogLong(value);
    }

    @Api.Stable(since="2.8.0")
    public static CogLong cogify(Long value) {
        return value == null ? null : new CogLong(value);
    }

    @Api.Stable(since="2.8.0")
    public static CogDouble cogify(double value) {
        return new CogDouble(value);
    }

    @Api.Stable(since="2.8.0")
    public static CogDouble cogify(Double value) {
        return value == null ? null : new CogDouble(value);
    }

    @Api.Stable(since="2.8.0")
    public static CogEntity cogify(Entity value) {
        return value == null ? null : new CogEntity(value);
    }

    @Api.Stable(since="2.8.0")
    public static CogPlayer cogify(ServerPlayer value) {
        return value == null ? null : new CogPlayer(new WeakReference<ServerPlayer>(value));
    }

    @Api.Stable(since="2.8.0")
    public static CogPropertyManager cogify(CogLike value) {
        return value == null ? null : value.asCogManager();
    }
}

