/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.devui;

import com.mojang.blaze3d.platform.InputConstants;
import com.storyanvil.cogwheel.client.devui.DWButton;
import com.storyanvil.cogwheel.client.devui.DWCodeEditor;
import com.storyanvil.cogwheel.client.devui.DWConsole;
import com.storyanvil.cogwheel.client.devui.DWTabbedView;
import com.storyanvil.cogwheel.client.devui.DevWidget;
import com.storyanvil.cogwheel.network.devui.DevEarlySyncPacket;
import com.storyanvil.cogwheel.network.devui.DevNetwork;
import com.storyanvil.cogwheel.network.devui.DevResyncRequest;
import java.util.ArrayList;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="storyanvil_cogwheel", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class DevUI
implements GuiEventListener {
    public static final Lazy<KeyMapping> OPEN_DEVUI = Lazy.of(() -> new KeyMapping("ui.storyanvil_cogwheel.dev_ui", InputConstants.Type.KEYSYM, 96, "ui.storyanvil_cogwheel"));
    public static final ResourceLocation ATLAS = ResourceLocation.fromNamespaceAndPath((String)"storyanvil_cogwheel", (String)"textures/gui/devui.png");
    public static final int ATLAS_SIZE = 256;
    protected static DevUI instance;
    public static boolean permitted;
    protected DevWidget hovered = null;
    protected float hoverTime = 0.0f;
    private ArrayList<DevWidget> widgets = new ArrayList();
    protected int screenWidth = 0;
    protected int screenHeight = 0;
    protected Font font;
    boolean fullscreen = false;
    protected int panelLeft = 0;
    protected int panelTop = 0;
    protected boolean drawConsole = false;
    private DWConsole console;
    DWTabbedView tabs;

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)OPEN_DEVUI.get());
    }

    public DevUI() {
        instance = this;
        this.font = Minecraft.m_91087_().f_91062_;
        this.addWidget(new DWButton(0, 0, 11, 11, 0, 0, 11, 11, (Component)Component.m_237115_((String)"ui.storyanvil_cogwheel.devui.fullscreen")){

            @Override
            public void press(int btn) {
                if (btn == 0) {
                    DevUI.this.fullscreen = !DevUI.this.fullscreen;
                    DevUI.this.scheduleResize();
                }
            }
        });
        this.addWidget(new DWButton(11, 0, 11, 11, 10, 0, 11, 11, (Component)Component.m_237115_((String)"ui.storyanvil_cogwheel.devui.resync")){

            @Override
            public void press(int btn) {
                if (btn == 0) {
                    DevNetwork.sendToServer(new DevEarlySyncPacket(permitted, false));
                    DevNetwork.sendToServer(new DevResyncRequest());
                }
            }
        });
        this.addWidget(new DWButton(22, 0, 11, 11, 20, 0, 11, 11, (Component)Component.m_237115_((String)"ui.storyanvil_cogwheel.devui.console")){

            @Override
            public void press(int btn) {
                if (btn == 0) {
                    instance.openConsole();
                }
            }
        });
        this.addWidget(new DWButton(33, 0, 11, 11, 30, 0, 11, 11, (Component)Component.m_237115_((String)"ui.storyanvil_cogwheel.devui.run")){

            @Override
            public void press(int btn) {
                DWTabbedView.Tab s;
                if (btn == 0 && (s = DevUI.instance.tabs.selected) instanceof DWCodeEditor) {
                    DWCodeEditor editor = (DWCodeEditor)s;
                    editor.run();
                }
            }
        });
        this.addWidget(new DWButton(44, 0, 11, 11, 40, 0, 11, 11, (Component)Component.m_237115_((String)"ui.storyanvil_cogwheel.devui.save")){

            @Override
            public void press(int btn) {
                DWTabbedView.Tab s;
                if (btn == 0 && (s = DevUI.instance.tabs.selected) instanceof DWCodeEditor) {
                    DWCodeEditor editor = (DWCodeEditor)s;
                    editor.save();
                }
            }
        });
        this.tabs = this.addWidget(new DWTabbedView(0, 12, 0, 0){

            @Override
            public void resize(@NotNull Minecraft minecraft, int width, int height) {
                this.setWidth(this.ui().screenWidth - this.ui().panelLeft);
                this.setHeight(DevUI.this.screenHeight - this.getRawTop());
                super.resize(minecraft, width, height);
            }
        });
        this.console = this.addWidget(new DWConsole());
    }

    public void openConsole() {
        this.drawConsole = true;
    }

    public void init() {
        this.hovered = null;
    }

    public void renderLogic(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick, int width, int height) {
        DevWidget widget;
        int i;
        if (this.screenWidth != width || this.screenHeight != height) {
            this.resizeLogic(Minecraft.m_91087_(), width, height);
        }
        g.m_280509_(this.panelLeft, this.panelTop, this.screenWidth, this.screenHeight, -15461087);
        DevWidget oldHovered = this.hovered;
        boolean allowHover = true;
        this.hovered = null;
        if (this.drawConsole) {
            this.hovered = this.console;
            allowHover = false;
        }
        for (i = 0; i < this.widgets.size(); ++i) {
            boolean hover;
            widget = this.widgets.get(i);
            boolean bl = hover = allowHover && widget.isHovered(mouseX, mouseY);
            if (hover) {
                this.hovered = widget;
                this.hoverTime = this.hovered != oldHovered ? 0.0f : (this.hoverTime += partialTick);
            }
            widget.render(g, mouseX, mouseY, partialTick, hover, this.hoverTime);
        }
        for (i = 0; i < this.widgets.size(); ++i) {
            widget.renderLast(g, mouseX, mouseY, partialTick, this.hovered == (widget = this.widgets.get(i)), this.hoverTime);
        }
    }

    public void resizeLogic(@NotNull Minecraft minecraft, int width, int height) {
        this.screenWidth = width;
        this.screenHeight = height;
        this.panelTop = 0;
        this.panelLeft = this.fullscreen ? 0 : this.screenWidth / 2;
        for (int i = 0; i < this.widgets.size(); ++i) {
            DevWidget widget = this.widgets.get(i);
            widget.resize(minecraft, width, height);
        }
    }

    public boolean m_7933_(int key, int scancode, int mods) {
        if (this.drawConsole) {
            return this.console.m_7933_(key, scancode, mods);
        }
        return this.tabs.selected != null && this.tabs.selected.m_7933_(key, scancode, mods);
    }

    public void m_93692_(boolean pFocused) {
    }

    public boolean m_93696_() {
        return true;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int button) {
        return this.hovered != null && this.hovered.m_6375_(pMouseX, pMouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.hovered != null && this.hovered.m_6050_(mouseX, mouseY, delta);
    }

    public <T extends DevWidget> T addWidget(T widget) {
        this.widgets.add(widget);
        this.scheduleResize();
        return widget;
    }

    public void scheduleResize() {
        this.screenHeight = -1;
    }

    public boolean m_7920_(int key, int scancode, int mods) {
        if (this.hovered != null && this.hovered.m_7920_(key, scancode, mods)) {
            return true;
        }
        return this.tabs.selected != null && this.tabs.selected.m_7920_(key, scancode, mods);
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (this.hovered != null && this.hovered.m_5534_(pCodePoint, pModifiers)) {
            return true;
        }
        return this.tabs.selected != null && this.tabs.selected.m_5534_(pCodePoint, pModifiers);
    }

    public void m_94757_(double pMouseX, double pMouseY) {
        if (this.hovered != null) {
            this.hovered.m_94757_(pMouseX, pMouseY);
        }
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        return this.hovered != null && this.hovered.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        return this.hovered != null && this.hovered.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    static {
        permitted = false;
    }
}

