/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.screen;

import com.storyanvil.cogwheel.network.mc.DialogBound;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DialogMessageScreen
extends Screen {
    private DialogBound bound;
    private int selectedButton = -1;
    private ResourceLocation image = null;
    private float time = 0.0f;
    private int boxLeft = 0;
    private int boxRight = 0;
    private int boxTop = 0;
    private int boxBottom = 0;
    private int boxWidth = 0;
    private int boxHeight = 0;
    private int imageWidth = 0;
    private int textX = 0;
    private int textY = 0;
    private int textEnd = 0;

    public DialogMessageScreen(DialogBound bound) {
        super((Component)Component.m_237115_((String)"ui.storyanvil_cogwheel.dialog_choice"));
        this.bound = bound;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6913_() {
        return false;
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.boxLeft == 0) {
            this.m_6574_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
        }
        this.selectedButton = -1;
        Font font = Minecraft.m_91087_().f_91062_;
        guiGraphics.m_280509_(this.boxLeft, this.boxTop, this.boxRight, this.boxBottom, -939524096);
        guiGraphics.m_280411_(this.image, this.boxLeft, this.boxBottom - this.imageWidth, this.imageWidth, this.imageWidth, 0.0f, 0.0f, 100, 100, 100, 100);
        guiGraphics.m_280488_(font, this.bound.getNpcName(), this.textX, this.textY, 0x55FF55);
        this.time += pPartialTick;
        FormattedText formattedText = FormattedText.m_130775_((String)this.bound.getRequest().substring(0, Math.min((int)this.time, this.bound.getRequest().length())));
        Objects.requireNonNull(font);
        guiGraphics.m_280554_(font, formattedText, this.textX, this.textY + 9 + 5, this.textEnd, 0xFFFFFF);
    }

    public void m_6574_(@NotNull Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        Font font = Minecraft.m_91087_().f_91062_;
        this.boxWidth = Mth.m_14045_((int)((int)((float)width / 100.0f * 70.0f)), (int)100, (int)350);
        this.boxHeight = Mth.m_14045_((int)((int)((float)height / 100.0f * 30.0f)), (int)50, (int)150);
        this.boxTop = height / 4 * 3 - this.boxHeight / 2;
        this.boxLeft = width / 2 - this.boxWidth / 2;
        this.boxRight = this.boxLeft + this.boxWidth;
        this.boxBottom = this.boxTop + this.boxHeight;
        this.imageWidth = Math.max(this.boxWidth / 3, this.boxHeight);
        this.textX = this.boxLeft + this.imageWidth + 15;
        this.textY = this.boxTop + 5;
        this.textEnd = this.boxWidth - this.imageWidth - 30;
        this.image = ResourceLocation.fromNamespaceAndPath((String)"storyanvil_cogwheel", (String)("textures/dialog/" + this.bound.getTexture() + ".png"));
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.selectedButton == -1) {
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }
        return true;
    }
}

