/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.storyanvil.cogwheel.data.StoryCodec;
import com.storyanvil.cogwheel.util.StoryUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class StoryCodecs {
    public static final StoryCodec<Boolean> BOOLEAN = new StoryCodec<Boolean>((a, b) -> b.writeBoolean(a.booleanValue()), FriendlyByteBuf::readBoolean);
    public static final StoryCodec<Byte> BYTE = new StoryCodec<Byte>((a, b) -> b.writeByte((int)a.byteValue()), FriendlyByteBuf::readByte);
    public static final StoryCodec<Integer> INTEGER = new StoryCodec<Integer>((a, b) -> b.writeInt(a.intValue()), FriendlyByteBuf::readInt);
    public static final StoryCodec<Long> LONG = new StoryCodec<Long>((a, b) -> b.writeLong(a.longValue()), FriendlyByteBuf::readLong);
    public static final StoryCodec<Float> FLOAT = new StoryCodec<Float>((a, b) -> b.writeFloat(a.floatValue()), FriendlyByteBuf::readFloat);
    public static final StoryCodec<Double> DOUBLE = new StoryCodec<Double>((a, b) -> b.writeDouble(a.doubleValue()), FriendlyByteBuf::readDouble);
    public static final StoryCodec<String> STRING = new StoryCodec<String>((a, b) -> StoryUtils.encodeString(b, a), StoryUtils::decodeString);
    public static final StoryCodec<JsonObject> JSON = new StoryCodec<JsonObject>((a, b) -> StoryUtils.encodeString(b, a.toString()), b -> JsonParser.parseString((String)StoryUtils.decodeString(b)).getAsJsonObject());
    public static final StoryCodec<ResourceLocation> RESOURCE_LOC = new StoryCodec<ResourceLocation>((a, b) -> {
        StoryUtils.encodeString(b, a.m_135827_());
        StoryUtils.encodeString(b, a.m_135815_());
    }, b -> ResourceLocation.fromNamespaceAndPath((String)StoryUtils.decodeString(b), (String)StoryUtils.decodeString(b)));
    public static final StoryCodec<Component> COMPONENT = new StoryCodec<Component>((a, b) -> StoryUtils.encodeString(b, Component.Serializer.m_237122_((Component)a)), b -> Component.Serializer.m_130701_((String)StoryUtils.decodeString(b)));
    public static final StoryCodec<Item> ITEM = StoryCodecs.getRegistryCodec(ForgeRegistries.ITEMS);
    public static final StoryCodec<Block> BLOCK = StoryCodecs.getRegistryCodec(ForgeRegistries.BLOCKS);
    public static final StoryCodec<Biome> BIOME = StoryCodecs.getRegistryCodec(ForgeRegistries.BIOMES);
    public static final StoryCodec<EntityType<?>> ENTITY_TYPE = StoryCodecs.getRegistryCodec(ForgeRegistries.ENTITY_TYPES);
    public static final StoryCodec<Attribute> ATTRIBUTE = StoryCodecs.getRegistryCodec(ForgeRegistries.ATTRIBUTES);
    public static final StoryCodec<Enchantment> ENCHANTMENT = StoryCodecs.getRegistryCodec(ForgeRegistries.ENCHANTMENTS);

    public static <T> StoryCodec<List<T>> getListCodec(StoryCodec<T> codec) {
        return new StoryCodec<List<T>>((ts, buf) -> {
            buf.writeInt(ts.size());
            for (int i = 0; i < ts.size(); ++i) {
                codec.encode((Object)ts.get(i), (FriendlyByteBuf)buf);
            }
        }, buf -> {
            int l = buf.readInt();
            ArrayList q = new ArrayList(l);
            for (int i = 0; i < l; ++i) {
                q.add(codec.decode((FriendlyByteBuf)buf));
            }
            return q;
        });
    }

    public static <T> StoryCodec<T> getRegistryCodec(IForgeRegistry<T> registry) {
        return new StoryCodec<Object>((a, b) -> StoryUtils.encodeString(b, registry.getKey(a).toString()), b -> registry.getValue(ResourceLocation.parse((String)StoryUtils.decodeString(b))));
    }
}

