/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.data;

import com.storyanvil.cogwheel.network.devui.DevNetwork;
import com.storyanvil.cogwheel.network.mc.CogwheelPacketHandler;
import com.storyanvil.cogwheel.network.mc.Notification;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public interface StoryPacket {
    default public void handle(Supplier<NetworkEvent.Context> ctx) {
        try {
            ctx.get().enqueueWork(() -> {
                DevNetwork.log.debug("Handling {} as {}", (Object)this.toString(), (Object)this.getClass().getCanonicalName());
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                    this.onServerUnsafe(ctx);
                } else {
                    this.onClientUnsafe(ctx);
                }
            });
            ctx.get().setPacketHandled(true);
        }
        catch (Exception e) {
            DevNetwork.log.error("Exception while handling packet {}", (Object)this.getClass().getCanonicalName(), (Object)e);
            throw e;
        }
    }

    default public void onClientUnsafe(Supplier<NetworkEvent.Context> ctx) {
    }

    default public void onServerUnsafe(Supplier<NetworkEvent.Context> ctx) {
    }

    default public void error(ServerPlayer plr, String err) {
        CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.PLAYER.with(() -> plr), (Object)new Notification((Component)Component.m_237113_((String)"Invalid Packet"), (Component)Component.m_237113_((String)err)));
    }
}

