/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.devui;

import com.storyanvil.cogwheel.client.devui.DWCodeEditor;
import com.storyanvil.cogwheel.data.StoryCodec;
import com.storyanvil.cogwheel.data.StoryCodecBuilder;
import com.storyanvil.cogwheel.data.StoryCodecs;
import com.storyanvil.cogwheel.data.StoryPacket;
import com.storyanvil.cogwheel.network.devui.DevEditorState;
import com.storyanvil.cogwheel.network.devui.DevNetwork;
import com.storyanvil.cogwheel.network.devui.editor.DevEditorSession;
import com.storyanvil.cogwheel.network.mc.CogwheelPacketHandler;
import com.storyanvil.cogwheel.network.mc.Notification;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record DevOpenFile(ResourceLocation script) implements StoryPacket
{
    public static final StoryCodec<DevOpenFile> CODEC = StoryCodecBuilder.build(StoryCodecBuilder.Prop(DevOpenFile::script, StoryCodecs.RESOURCE_LOC), DevOpenFile::new);

    @Override
    public void onServerUnsafe(Supplier<NetworkEvent.Context> ctx) {
        DevEditorSession session = DevEditorSession.createOrGet(this.script());
        try {
            session.read();
            session.addConnection(ctx.get().getSender());
        }
        catch (IOException e) {
            DevNetwork.log.error("Error while starting session", (Throwable)e);
            CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)ctx.get()).getSender()), (Object)new Notification((Component)Component.m_237113_((String)"File can't be opened!"), (Component)Component.m_237113_((String)"Unknown error on serverside!")));
            session.dispose();
        }
    }

    @Override
    public void onClientUnsafe(Supplier<NetworkEvent.Context> ctx) {
        DWCodeEditor editor = DWCodeEditor.getOrCreateEditor(this.script);
        DevNetwork.sendToServer(new DevEditorState(this.script, (byte)-127));
    }

    @Override
    public String toString() {
        return "DevOpenFile{script=" + String.valueOf(this.script) + "}";
    }
}

