/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.mc;

import com.storyanvil.cogwheel.data.CameraPos;
import com.storyanvil.cogwheel.network.mc.CogwheelClientPacketHandler;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class CameraTransitionBound {
    private CameraPos pos1;
    private CameraPos pos2;
    private float goal;

    public CameraPos getPos1() {
        return this.pos1;
    }

    public void setPos1(CameraPos pos1) {
        this.pos1 = pos1;
    }

    public CameraPos getPos2() {
        return this.pos2;
    }

    public void setPos2(CameraPos pos2) {
        this.pos2 = pos2;
    }

    public float getGoal() {
        return this.goal;
    }

    public void setGoal(float goal) {
        this.goal = goal;
    }

    public CameraTransitionBound() {
    }

    public CameraTransitionBound(CameraPos pos1, CameraPos pos2, float goal) {
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.goal = goal;
    }

    public void encode(FriendlyByteBuf byteBuf) {
        if (this.pos1 == null) {
            byteBuf.writeBoolean(false);
        } else {
            byteBuf.writeBoolean(true);
            this.pos1.encode(byteBuf);
        }
        if (this.pos2 == null) {
            byteBuf.writeBoolean(false);
        } else {
            byteBuf.writeBoolean(true);
            this.pos2.encode(byteBuf);
        }
        byteBuf.writeFloat(this.goal);
    }

    public static CameraTransitionBound decode(FriendlyByteBuf byteBuf) {
        CameraTransitionBound bound = new CameraTransitionBound();
        bound.pos1 = byteBuf.readBoolean() ? CameraPos.decode(byteBuf) : null;
        if (byteBuf.readBoolean()) {
            bound.pos2 = CameraPos.decode(byteBuf);
        } else {
            bound.pos1 = null;
        }
        bound.goal = byteBuf.readFloat();
        return bound;
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> this.lambda$handle$1((Supplier)contextSupplier)));
        contextSupplier.get().setPacketHandled(true);
    }

    public String toString() {
        return "CameraTransitionBound{pos1=" + String.valueOf(this.pos1) + ", pos2=" + String.valueOf(this.pos2) + ", goal=" + this.goal + "}";
    }

    private /* synthetic */ Callable lambda$handle$1(Supplier contextSupplier) {
        return () -> this.lambda$handle$0((Supplier)contextSupplier);
    }

    private /* synthetic */ Object lambda$handle$0(Supplier contextSupplier) throws Exception {
        return CogwheelClientPacketHandler.cameraTrans(this, contextSupplier);
    }
}

