/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.util;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.config.CogwheelConfig;
import com.storyanvil.cogwheel.util.WeakList;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.ApiStatus;

@Api.Internal
@ApiStatus.Internal
public class ObjectMonitor<T extends IMonitored> {
    private static final WeakList<ObjectMonitor<?>> MONITOR_REGISTRY = new WeakList();
    private final WeakList<T> objects;
    private final int id;

    private static synchronized int register(ObjectMonitor<?> monitor) {
        if (CogwheelConfig.isMonitorDisabled()) {
            return 0;
        }
        int id = MONITOR_REGISTRY.size();
        MONITOR_REGISTRY.add(monitor);
        return id;
    }

    @Api.Internal
    @ApiStatus.Internal
    public static synchronized void dumpAll(StringBuilder sb) {
        if (CogwheelConfig.isMonitorDisabled()) {
            return;
        }
        try {
            for (int i = 0; i < MONITOR_REGISTRY.size(); ++i) {
                ObjectMonitor<?> monitor = MONITOR_REGISTRY.get(i);
                if (monitor == null) {
                    sb.append("=NULL MONITOR=\n");
                    continue;
                }
                monitor.dump(sb);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Api.Internal
    @ApiStatus.Internal
    public ObjectMonitor() {
        if (CogwheelConfig.isMonitorDisabled()) {
            this.objects = null;
            this.id = 0;
            return;
        }
        this.objects = new WeakList();
        this.id = ObjectMonitor.register(this);
    }

    @Api.Internal
    @ApiStatus.Internal
    public void register(T object) {
        if (CogwheelConfig.isMonitorDisabled()) {
            return;
        }
        if (this.objects.contains(object)) {
            return;
        }
        this.objects.add(object);
    }

    @Api.Internal
    @ApiStatus.Internal
    public String dump() {
        StringBuilder sb = new StringBuilder();
        this.dump(sb);
        return sb.toString();
    }

    @Api.Internal
    @ApiStatus.Internal
    public void dump(StringBuilder sb) {
        if (CogwheelConfig.isMonitorDisabled()) {
            return;
        }
        sb.append("=== === === OBJECT MONITOR REPORT === === ===\n");
        sb.append("MONITOR ID: ").append(this.id).append("\nOBJECTS:\n");
        for (int i = 0; i < this.objects.size(); ++i) {
            WeakReference<T> ref = this.objects.getRef(i);
            if (ref.refersTo(null)) {
                sb.append("    NULL\n");
                continue;
            }
            IMonitored t = (IMonitored)ref.get();
            if (t == null) {
                sb.append("    UNEXPECTED NULL\n");
                continue;
            }
            sb.append("    ").append(t.getClass().getCanonicalName()).append(": ");
            t.reportState(sb);
            sb.append('\n');
        }
    }

    @Api.Internal
    @ApiStatus.Internal
    public WeakList<T> getObjects() {
        return this.objects;
    }

    public static interface IMonitored {
        public void reportState(StringBuilder var1);
    }
}

