/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.devui;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.client.devui.DWTabbedView;
import com.storyanvil.cogwheel.client.devui.DevHighlighters;
import com.storyanvil.cogwheel.client.devui.DevUI;
import com.storyanvil.cogwheel.network.devui.DevEditorLine;
import com.storyanvil.cogwheel.network.devui.DevEditorState;
import com.storyanvil.cogwheel.network.devui.DevEditorUserDelta;
import com.storyanvil.cogwheel.network.devui.DevFlush;
import com.storyanvil.cogwheel.network.devui.DevNetwork;
import com.storyanvil.cogwheel.network.devui.DevRunAndFlush;
import com.storyanvil.cogwheel.network.devui.DevTypeCallback;
import com.storyanvil.cogwheel.util.Bi;
import com.storyanvil.cogwheel.util.StoryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class DWCodeEditor
extends DWTabbedView.Tab {
    private static final HashMap<ResourceLocation, DWCodeEditor> editors = new HashMap();
    private ResourceLocation rl;
    private String name;
    private ArrayList<Bi<String, MutableComponent>> code = new ArrayList();
    private ArrayList<Cursor> cursors = new ArrayList();
    private int scroll = 0;
    private int codeLeft = 0;
    private int scrollHor = 0;
    private boolean shift = false;
    private Highlighter highlighter;
    private String myName;
    private Cursor mine = null;
    private float blinker = 0.0f;
    private boolean blink = false;
    private static final MutableComponent EMPTY = Component.m_237113_((String)"UNHIGHLIGHTED").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
    private static final MutableComponent NODATA = Component.m_237113_((String)"NO DATA").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
    private static final MutableComponent FAILURE = Component.m_237113_((String)"HIGHLIGHTER FAILURE").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});

    public static DWCodeEditor getOrCreateEditor(ResourceLocation script) {
        if (editors.containsKey(script)) {
            return editors.get(script);
        }
        DWCodeEditor editor = new DWCodeEditor(script);
        editors.put(script, editor);
        DevUI.instance.tabs.openAndSelect(editor);
        return editor;
    }

    private DWCodeEditor(ResourceLocation rl) {
        this.rl = rl;
        this.name = rl.toString();
        String path = rl.m_135815_();
        this.highlighter = DWCodeEditor.getHighlighterByFileName(path);
        this.myName = Minecraft.m_91087_().f_91074_.m_6302_();
    }

    public static Highlighter getHighlighterByFileName(String name) {
        if (name.endsWith(".sad")) {
            return new DevHighlighters.StoryAnvilDialog();
        }
        if (name.endsWith(".sa")) {
            return new DevHighlighters.CogScript();
        }
        return new DevHighlighters.Empty();
    }

    public static DWCodeEditor get(ResourceLocation lc) {
        return editors.get(lc);
    }

    public static void delete(ResourceLocation lc) {
        DWCodeEditor editor = editors.get(lc);
        DevUI.instance.tabs.close(editor);
        editors.remove(lc);
    }

    @Override
    public void renderS(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick, boolean isHovered, float timeHovered, int top, int left, int right, int bottom) {
        int i;
        int y = top;
        g.m_280588_(left, top, right, bottom);
        int codeLeftt = this.codeLeft - this.scrollHor;
        for (i = this.scroll; i < this.code.size(); ++i) {
            MutableComponent b = this.code.get(i).getB();
            this.draw(g, codeLeftt, y, (Component)(b == null ? EMPTY : b), this.ui().font);
            Objects.requireNonNull(this.ui().font);
            y += 9;
        }
        g.m_280618_();
        this.blinker += partialTick;
        if (this.blinker > 10.0f) {
            this.blinker = 0.0f;
            this.blink = !this.blink;
        }
        for (i = 0; i < this.cursors.size(); ++i) {
            Cursor c = this.cursors.get(i);
            Objects.requireNonNull(this.ui().font);
            int t = 9 * (c.line - this.scroll) + top;
            int drawingLeft = c.drawingLeft + this.codeLeft;
            int right1 = drawingLeft + 1;
            Objects.requireNonNull(this.ui().font);
            int bottom1 = t + 9;
            if (this.blink) {
                this.fill(g, drawingLeft, t, right1, bottom1, c.color);
            }
            if (!StoryUtils.isHovering(mouseX, mouseY, drawingLeft - 2, right1 + 2, t - 2, bottom1 + 2)) continue;
            String tooltip = c.name;
            int tooltipWidth = this.ui().font.m_92895_(tooltip) + 10;
            Objects.requireNonNull(this.ui().font);
            int tooltipHeight = 9 + 10;
            this.fill(g, mouseX, mouseY, mouseX + tooltipWidth, mouseY + tooltipHeight, c.color);
            this.draw(g, mouseX + 5, mouseY + 5, tooltip, this.ui().font);
        }
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.shift) {
            this.scroll = Mth.m_14045_((int)(this.scroll + (pDelta > 0.0 ? -1 : 1)), (int)0, (int)(this.code.size() - 1));
        } else {
            this.scrollHor = Math.max(this.scrollHor + (pDelta > 0.0 ? -4 : 4), 0);
        }
        return true;
    }

    @Override
    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.codeLeft = this.getLeft() + 5;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public synchronized void setCode(String code) {
        int i;
        this.code.clear();
        String[] lines = code.split("\n");
        for (i = 0; i < lines.length; ++i) {
            this.code.add(new Bi<String, MutableComponent>(lines[i], EMPTY));
        }
        for (i = 0; i < lines.length; ++i) {
            this.highlight(i);
        }
    }

    public synchronized void highlight(int line) {
        try {
            MutableComponent c = this.highlighter.highlight(line, this.code, this.code.get(line).getA());
            this.code.get(line).setB(c);
        }
        catch (Exception e) {
            CogwheelExecutor.log.error("Trying to highlight line \"{}\" with {}", new Object[]{this.code.get(line).getA(), this.highlighter.getClass().getCanonicalName(), e});
            this.code.get(line).setB(FAILURE);
        }
        for (int i = 0; i < this.cursors.size(); ++i) {
            Cursor c = this.cursors.get(i);
            if (c.line != line) continue;
            c.compute(this.code.get(line));
        }
    }

    private synchronized Cursor getCursor(String name) {
        for (int i = 0; i < this.cursors.size(); ++i) {
            Cursor c = this.cursors.get(i);
            if (!c.name.equals(name)) continue;
            return c;
        }
        return null;
    }

    public synchronized void handle(DevEditorLine devEditorLine) {
        Bi<String, MutableComponent> line;
        if (devEditorLine.linesTotal() != this.code.size()) {
            if (this.code.size() > devEditorLine.linesTotal()) {
                DevNetwork.sendToServer(new DevEditorState(this.rl, (byte)-127));
                return;
            }
            while (this.code.size() < devEditorLine.linesTotal()) {
                this.code.add(new Bi<String, MutableComponent>("", NODATA));
            }
        }
        if ((line = this.code.get(devEditorLine.lineNumber())).getA().equals(devEditorLine.line())) {
            return;
        }
        line.setA(devEditorLine.line());
        this.highlight(devEditorLine.lineNumber());
    }

    public synchronized void handle(DevEditorUserDelta delta) {
        Cursor c = this.getCursor(delta.name());
        if (c == null) {
            c = new Cursor();
            c.editor = this;
            c.name = delta.name();
            this.cursors.add(c);
            if (delta.name().equals(this.myName)) {
                this.mine = c;
            }
        }
        c.line = delta.line();
        c.pos = delta.pos();
        c.selectNextChars = delta.selected();
        c.color = delta.color();
    }

    @Override
    public boolean closingRequest() {
        DevNetwork.sendToServer(new DevEditorState(this.rl, (byte)-128));
        return true;
    }

    public boolean m_7933_(int code, int scanCode, int mods) {
        boolean bl = this.shift = (mods & 1) == 1;
        if (code == 263) {
            this.mine.setPosSafe(this.mine.pos - 1);
            this.mine.wrapLeft();
        } else if (code == 262) {
            this.mine.setPosSafe(this.mine.pos + 1);
            this.mine.wrapRight();
        } else if (code == 265) {
            this.mine.setLineSafe(this.mine.line - 1);
        } else if (code == 264) {
            this.mine.setLineSafe(this.mine.line + 1);
        } else if (code == 259) {
            DevNetwork.sendToServer(new DevTypeCallback(this.rl, "<backspace>", this.mine.toDelta()));
        } else if (code == 261) {
            DevNetwork.sendToServer(new DevTypeCallback(this.rl, "<delete>", this.mine.toDelta()));
        } else if (code == 268) {
            this.mine.setPosSafe(0);
        } else if (code == 269) {
            this.mine.setPosSafe(Integer.MAX_VALUE);
        } else if (code == 266) {
            this.mine.setLineSafe(0);
            this.mine.setPosSafe(0);
        } else if (code == 267) {
            this.mine.setLineSafe(Integer.MAX_VALUE);
            this.mine.setPosSafe(Integer.MAX_VALUE);
        } else if (code == 83 && (mods & 2) == 2) {
            this.save();
            return true;
        }
        return false;
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        this.shift = (pModifiers & 1) != 1;
        return false;
    }

    public boolean m_5534_(char c, int mods) {
        DevNetwork.sendToServer(new DevTypeCallback(this.rl, "" + c, this.mine.toDelta()));
        return true;
    }

    public void run() {
        DevNetwork.sendToServer(new DevRunAndFlush(this.rl));
    }

    public void save() {
        DevNetwork.sendToServer(new DevFlush(this.rl));
    }

    public static class Cursor {
        private DWCodeEditor editor;
        private int line = 0;
        private int pos = 0;
        private int selectNextChars = 0;
        private String name = ">huynya<";
        private Component sup;
        private int color = 0;
        private boolean onEndOfLine = false;
        private int drawingLeft = 0;

        public String toString() {
            return "Cursor{line=" + this.line + ", pos=" + this.pos + ", selectNextChars=" + this.selectNextChars + ", sup=" + String.valueOf(this.sup) + ", name='" + this.name + "'}";
        }

        public void compute(Bi<String, MutableComponent> line) {
            this.sup = StoryUtils.subComponent(line.getB(), 0, this.pos);
            this.drawingLeft = this.editor.ui().font.m_92852_((FormattedText)this.sup);
            this.onEndOfLine = this.pos == line.getA().length() + 1;
        }

        public void wrapRight() {
            if (this.onEndOfLine) {
                this.pos = 0;
                this.setLineSafe(this.line + 1);
            }
        }

        public void wrapLeft() {
            if (this.pos == 0 && this.line > 0) {
                --this.line;
                Bi<String, MutableComponent> prv = this.editor.code.get(this.line);
                this.pos = prv.getA().length() + 1;
                this.compute(prv);
                this.sync();
            }
        }

        public void setPosSafe(int pos) {
            Bi<String, MutableComponent> line = this.editor.code.get(this.line);
            this.pos = Mth.m_14045_((int)pos, (int)0, (int)(line.getA().length() + 1));
            this.compute(line);
            this.sync();
        }

        public void setLineSafe(int line) {
            this.line = line = Mth.m_14045_((int)line, (int)0, (int)(this.editor.code.size() - 1));
            this.setPosSafe(this.pos);
        }

        public void sync() {
            this.editor.blink = true;
            this.editor.blinker = 0.0f;
            DevNetwork.sendToServer(new DevEditorUserDelta(this.editor.rl, this.line, this.pos, this.selectNextChars, this.editor.myName, this.color));
        }

        public DevEditorUserDelta toDelta() {
            return new DevEditorUserDelta(this.editor.rl, this.line, this.pos, this.selectNextChars, this.editor.myName, this.color);
        }
    }

    public static abstract class Highlighter {
        public abstract MutableComponent highlight(int var1, ArrayList<Bi<String, MutableComponent>> var2, String var3);
    }
}

