/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.devui;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.client.devui.DWCodeEditor;
import com.storyanvil.cogwheel.client.devui.DWTabbedView;
import com.storyanvil.cogwheel.util.Bi;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class DWCodeViewer
extends DWTabbedView.Tab {
    private String name;
    private ArrayList<Bi<String, MutableComponent>> code = new ArrayList();
    private int scroll = 0;
    private int scrollHor = 0;
    private boolean shift = false;
    private int codeLeft = 0;
    private DWCodeEditor.Highlighter highlighter;
    private static final MutableComponent EMPTY = Component.m_237113_((String)"UNHIGHLIGHTED").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
    private static final MutableComponent FAILURE = Component.m_237113_((String)"HIGHLIGHTER FAILURE").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});

    public DWCodeViewer(String name) {
        this.name = name;
        this.highlighter = DWCodeEditor.getHighlighterByFileName(name);
    }

    @Override
    public void renderS(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick, boolean isHovered, float timeHovered, int top, int left, int right, int bottom) {
        int y = top;
        g.m_280588_(left, top, right, bottom);
        int codeLeftt = this.codeLeft - this.scrollHor;
        for (int i = this.scroll; i < this.code.size(); ++i) {
            MutableComponent b = this.code.get(i).getB();
            this.draw(g, codeLeftt, y, (Component)(b == null ? EMPTY : b), this.ui().font);
            Objects.requireNonNull(this.ui().font);
            y += 9;
        }
        g.m_280618_();
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        this.shift = (pModifiers & 1) == 1;
        return false;
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        this.shift = (pModifiers & 1) == 1;
        return false;
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.shift) {
            this.scroll = Mth.m_14045_((int)(this.scroll + (pDelta > 0.0 ? -1 : 1)), (int)0, (int)(this.code.size() - 1));
        } else {
            this.scrollHor = Math.max(this.scrollHor + (pDelta > 0.0 ? -4 : 4), 0);
        }
        return true;
    }

    @Override
    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.codeLeft = this.getLeft() + 5;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public synchronized void setCode(String code) {
        int i;
        this.code.clear();
        String[] lines = code.split("\n");
        for (i = 0; i < lines.length; ++i) {
            this.code.add(new Bi<String, MutableComponent>(lines[i], EMPTY));
        }
        for (i = 0; i < lines.length; ++i) {
            this.highlight(i);
        }
    }

    public synchronized void highlight(int line) {
        try {
            MutableComponent c = this.highlighter.highlight(line, this.code, this.code.get(line).getA());
            this.code.get(line).setB(c);
        }
        catch (Exception e) {
            CogwheelExecutor.log.error("Trying to highlight line \"{}\" with {}", new Object[]{this.code.get(line).getA(), this.highlighter.getClass().getCanonicalName(), e});
            this.code.get(line).setB(FAILURE);
        }
    }
}

