/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.devui;

import com.storyanvil.cogwheel.client.devui.DevUI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public abstract class DevWidget
implements GuiEventListener {
    private int left;
    private int top;
    private int width;
    private int height;
    private int right;
    private int bottom;

    public DevWidget() {
    }

    public DevWidget(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
    }

    public void render(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick, boolean isHovered, float timeHovered) {
        this.renderS(g, mouseX, mouseY, partialTick, isHovered, timeHovered, this.getTop(), this.getLeft(), this.getRight(), this.getBottom());
    }

    public void renderLast(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick, boolean isHovered, float timeHovered) {
        this.renderLastS(g, mouseX, mouseY, partialTick, isHovered, timeHovered, this.getTop(), this.getLeft(), this.getRight(), this.getBottom());
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        this.right = this.left + this.getWidth();
        this.bottom = this.top + this.getHeight();
    }

    public void renderS(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick, boolean isHovered, float timeHovered, int top, int left, int right, int bottom) {
    }

    public void renderLastS(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick, boolean isHovered, float timeHovered, int top, int left, int right, int bottom) {
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return (mouseX -= this.offX()) >= this.left && (mouseY -= this.offY()) >= this.top && mouseX <= this.right && mouseY <= this.bottom;
    }

    protected void blitImage(GuiGraphics g, int x, int y, int w, int h, int ox, int oy, int ow, int oh) {
        g.m_280411_(DevUI.ATLAS, x, y, w, h, (float)ox, (float)oy, ow, oh, 256, 256);
    }

    protected void fill(GuiGraphics g, int left, int top, int right, int bottom, int color) {
        g.m_280509_(left, top, right, bottom, color);
    }

    protected void draw(GuiGraphics g, int x, int y, String str, Font font) {
        g.m_280056_(font, str, x, y, 0xFFFFFF, false);
    }

    protected void draw(GuiGraphics g, int x, int y, String str, Font font, int color) {
        g.m_280056_(font, str, x, y, color, false);
    }

    protected void draw(GuiGraphics g, int x, int y, Component str, Font font) {
        g.m_280614_(font, str, x, y, 0xFFFFFF, false);
    }

    protected void draw(GuiGraphics g, int x, int y, Component str, Font font, int color) {
        g.m_280614_(font, str, x, y, color, false);
    }

    protected DevUI ui() {
        return DevUI.instance;
    }

    protected int offX() {
        return this.ui().panelLeft;
    }

    protected int offY() {
        return this.ui().panelTop;
    }

    public int getLeft() {
        return this.offX() + this.left;
    }

    public int getTop() {
        return this.offY() + this.top;
    }

    public int getRawLeft() {
        return this.left;
    }

    public int getRawTop() {
        return this.top;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRight() {
        return this.offX() + this.right;
    }

    public int getBottom() {
        return this.offY() + this.bottom;
    }

    public void setHeight(int height) {
        this.height = height;
        this.bottom = this.top + height;
    }

    public void setWidth(int width) {
        this.width = width;
        this.right = this.left + width;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public String toString() {
        return "DevWidget{left=" + this.left + ", top=" + this.top + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", right=" + this.right + ", bottom=" + this.bottom + "}";
    }

    public void m_93692_(boolean pFocused) {
    }

    public boolean m_93696_() {
        return true;
    }
}

