/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure;

import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.cog.CogLike;
import com.storyanvil.cogwheel.infrastructure.cog.CogString;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.EasyPropManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CogPropertyManager
extends CogLike {
    public static final NullManager nullManager = new NullManager();

    public boolean hasOwnProperty(String var1);

    @Nullable
    public CogPropertyManager getProperty(String var1, ArgumentData var2, DispatchedScript var3) throws PreventSubCalling;

    public boolean equalsTo(CogPropertyManager var1);

    @Contract(value="!null -> param1", pure=true)
    @NotNull
    public static CogPropertyManager noNull(@Nullable CogPropertyManager manager) {
        if (manager == null) {
            return nullManager;
        }
        return manager;
    }

    default public String convertToString() {
        return this.toString();
    }

    default public CogString convertToCogString() {
        return new CogString(this.convertToString());
    }

    @Override
    default public CogPropertyManager asCogManager() {
        return this;
    }

    public static class NullManager
    implements CogPropertyManager {
        private static final EasyPropManager MANAGER = new EasyPropManager("nil", NullManager::registerProps);

        private static void registerProps(EasyPropManager manager) {
        }

        @Contract(pure=true)
        private NullManager() {
        }

        @Override
        public boolean hasOwnProperty(String name) {
            return MANAGER.hasOwnProperty(name);
        }

        @Override
        @Nullable
        public CogPropertyManager getProperty(String name, ArgumentData args, DispatchedScript script) {
            return MANAGER.get(name).handle(name, args, script, this);
        }

        @Override
        public boolean equalsTo(CogPropertyManager o) {
            return o instanceof NullManager;
        }

        @Override
        public String convertToString() {
            return "NULL";
        }
    }
}

