/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.actions;

import com.google.gson.JsonObject;
import com.storyanvil.cogwheel.infrastructure.StoryAction;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryAnimator;
import com.storyanvil.cogwheel.network.mc.AnimationBound;
import com.storyanvil.cogwheel.network.mc.CogwheelPacketHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class AnimationAction
extends StoryAction<StoryAnimator> {
    private final String animation;
    private int ticks;

    public AnimationAction(String animationName, int ticks) {
        this.animation = animationName;
        this.ticks = ticks;
    }

    @Override
    public void proceed(@NotNull StoryAnimator myself) {
        CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)new AnimationBound(myself.getAnimatorID(), this.animation));
    }

    @Override
    public boolean freeToGo(StoryAnimator myself) {
        --this.ticks;
        if (this.ticks <= 0) {
            CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)new AnimationBound(myself.getAnimatorID(), "null"));
            return true;
        }
        return false;
    }

    @Override
    protected void toJSON(JsonObject obj) {
        super.toJSON(obj);
        obj.addProperty("ticks", (Number)this.ticks);
        obj.addProperty("animationName", this.animation);
    }
}

