/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.actions;

import com.google.gson.JsonObject;
import com.storyanvil.cogwheel.EventBus;
import com.storyanvil.cogwheel.infrastructure.StoryAction;
import com.storyanvil.cogwheel.util.LabelCloseable;

public class WaitForLabelAction
extends StoryAction<Object>
implements LabelCloseable {
    private String label;
    private int amount;

    public WaitForLabelAction(String label, int amount) {
        this.amount = amount;
        this.label = label;
    }

    public WaitForLabelAction(String label) {
        this.label = label;
        this.amount = 1;
    }

    @Override
    public void proceed(Object myself) {
        EventBus.register(this.label, this);
    }

    @Override
    public boolean freeToGo(Object myself) {
        return this.label == null;
    }

    @Override
    public void close(String label, StoryAction<?> host) {
        --this.amount;
        if (this.amount <= 0) {
            this.label = null;
        }
    }

    @Override
    protected void toJSON(JsonObject obj) {
        super.toJSON(obj);
        obj.addProperty("label", this.label);
        obj.addProperty("amount", (Number)this.amount);
    }
}

