/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.StoryAction;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryActionQueue;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryChatter;
import com.storyanvil.cogwheel.infrastructure.cog.CogArray;
import com.storyanvil.cogwheel.infrastructure.cog.CogPlayer;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.infrastructure.cog.SubCallPostPrevention;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.EasyPropManager;
import com.storyanvil.cogwheel.util.ObjectMonitor;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Queue;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoryLevel
implements StoryActionQueue<StoryLevel>,
StoryChatter,
ObjectMonitor.IMonitored {
    private static final ObjectMonitor<StoryLevel> MONITOR = new ObjectMonitor();
    private final Queue<StoryAction<? extends StoryLevel>> actionQueue = new ArrayDeque<StoryAction<? extends StoryLevel>>();
    private StoryAction current;
    private ServerLevel level;
    private static final EasyPropManager MANAGER = new EasyPropManager("level", StoryLevel::registerProps);

    @Override
    public <R> void addStoryAction(StoryAction<R> action) {
        this.actionQueue.add(action);
    }

    @Override
    public void chat(String text) {
        MutableComponent c = Component.m_237113_((String)text);
        for (ServerPlayer player : this.level.m_6907_()) {
            player.m_213846_((Component)c);
        }
    }

    public void tick(ServerLevel level) {
        this.level = level;
        if (this.current != null) {
            if (this.current.freeToGo(this)) {
                this.current = null;
            }
        } else {
            if (this.actionQueue.isEmpty()) {
                return;
            }
            this.current = this.actionQueue.remove();
            this.current.proceed(this);
        }
    }

    public StoryLevel() {
        MONITOR.register(this);
    }

    @Override
    public void reportState(StringBuilder sb) {
        for (StoryAction storyAction : this.actionQueue) {
            sb.append(storyAction.toString());
        }
        if (this.current != null) {
            sb.append(">").append(this.current);
        }
        if (this.level != null) {
            sb.append(" | ").append(this.level);
        }
    }

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("runCommand", (name, args, script, o) -> {
            StoryLevel sl = (StoryLevel)o;
            return sl.addChained(new StoryAction.Instant<StoryLevel>(){

                @Override
                public void proceed(StoryLevel myself) {
                    StoryLevel.executeCommand(myself, args.getString(0));
                }
            });
        });
        manager.reg("getPlayers", (name, args, script, o) -> {
            throw new PreventSubCalling(new SubCallPostPrevention(){

                @Override
                public void prevent(String variable) {
                    CogwheelExecutor.scheduleTickEvent(event -> {
                        ArrayList<CogPlayer> players = new ArrayList<CogPlayer>();
                        for (ServerPlayer player : ((ServerLevel)event.level).m_6907_()) {
                            players.add(new CogPlayer(new WeakReference<ServerPlayer>(player)));
                        }
                        script.put(variable, CogArray.getInstance(players));
                        CogwheelExecutor.schedule(script::lineDispatcher);
                    });
                }
            });
        });
        manager.reg("put", (name, args, script, o) -> {
            script.getEnvironment().getData().put(args.getString(0), args.requirePrimal(1));
            return null;
        });
        manager.reg("get", (name, args, script, o) -> script.getEnvironment().getData().get(args.getString(0)));
    }

    public static void executeCommand(StoryLevel myself, String command) {
        myself.level.m_7654_().m_129892_().m_230957_(new CommandSourceStack(CommandSource.f_80164_, new Vec3(0.0, 0.0, 0.0), new Vec2(0.0f, 0.0f), myself.level, 4, "COGWHEEL", (Component)Component.m_237113_((String)"COGWHEEL"), myself.level.m_7654_(), null), command);
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CogPropertyManager getProperty(String name, ArgumentData args, DispatchedScript script) {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    public boolean equalsTo(CogPropertyManager o) {
        return o == this;
    }

    public ServerLevel getLevel() {
        return this.level;
    }
}

