/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.mc;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.entity.NPCModel;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class AnimationDataBound {
    private String sources;

    @Contract(pure=true)
    public AnimationDataBound(String sources) {
        this.sources = sources;
    }

    @Contract(pure=true)
    public AnimationDataBound() {
        this.sources = null;
    }

    public void encode(@NotNull FriendlyByteBuf friendlyByteBuf) {
        int length = this.sources.length();
        friendlyByteBuf.writeInt(length);
        for (int i = 0; i < length; ++i) {
            friendlyByteBuf.writeByte((int)this.sources.charAt(i));
        }
    }

    @NotNull
    public static AnimationDataBound decode(@NotNull FriendlyByteBuf friendlyByteBuf) {
        AnimationDataBound dataBound = new AnimationDataBound();
        int length = friendlyByteBuf.readInt();
        byte[] str = new byte[length];
        for (int i = 0; i < length; ++i) {
            str[i] = friendlyByteBuf.readByte();
        }
        dataBound.sources = new String(str);
        return dataBound;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        String[] locs = this.sources.split("\\|");
        ResourceLocation[] locations = new ResourceLocation[locs.length];
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = ResourceLocation.parse((String)locs[i]);
        }
        NPCModel.animationSources = locations;
        CogwheelExecutor.log.info("Animation source got updated: {}", (Object)Arrays.toString(NPCModel.animationSources));
        ctx.get().setPacketHandled(true);
    }
}

