/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.mc;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.client.CutSceneManagement;
import com.storyanvil.cogwheel.client.screen.DialogChoiceScreen;
import com.storyanvil.cogwheel.client.screen.DialogMessageScreen;
import com.storyanvil.cogwheel.data.CameraPos;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryAnimator;
import com.storyanvil.cogwheel.network.mc.AnimationBound;
import com.storyanvil.cogwheel.network.mc.CameraForceBound;
import com.storyanvil.cogwheel.network.mc.CameraTransitionBound;
import com.storyanvil.cogwheel.network.mc.DialogBound;
import com.storyanvil.cogwheel.network.mc.DialogChoiceBound;
import com.storyanvil.cogwheel.network.mc.Notification;
import com.storyanvil.cogwheel.util.Bi;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkEvent;

public class CogwheelClientPacketHandler {
    public static void animationBound(AnimationBound animationBound, Supplier<NetworkEvent.Context> ctx) {
        CogwheelExecutor.scheduleTickEventClientSide(levelTickEvent -> {
            int d;
            ClientLevel level = (ClientLevel)levelTickEvent.level;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                CogwheelExecutor.log.warn("Failed to run animation bound as LocalPlayer is NULL!");
                return;
            }
            BlockPos pos = new BlockPos(player.m_146903_(), player.m_146904_(), player.m_146907_());
            AABB aabb = new AABB(pos.m_122020_(d = 1000).m_122030_(d).m_6625_(d), pos.m_122013_(d).m_122025_(d).m_6630_(d));
            List e = level.m_6249_((Entity)null, aabb, entity -> {
                StoryAnimator animator;
                return entity instanceof StoryAnimator && (animator = (StoryAnimator)entity).getAnimatorID().equals(animationBound.getAnimatorID());
            });
            if (e.isEmpty()) {
                CogwheelExecutor.log.warn("Failed to run animation bound for {}->{} | No StoryAnimators found", (Object)animationBound.getAnimatorID(), (Object)animationBound.getAnimation());
                return;
            }
            for (Entity entity2 : e) {
                StoryAnimator animator = (StoryAnimator)entity2;
                animator.pushAnimation(animationBound.getAnimation().replace('_', '.'));
            }
        });
    }

    public static Object dialogChoiceBound(DialogChoiceBound bound, Supplier<NetworkEvent.Context> contextSupplier) {
        if (bound.isClose()) {
            Minecraft.m_91087_().m_91152_(null);
        } else {
            Minecraft.m_91087_().m_91152_((Screen)new DialogChoiceScreen(bound));
        }
        return null;
    }

    public static Object dialogBound(DialogBound bound, Supplier<NetworkEvent.Context> contextSupplier) {
        if (bound.isClose()) {
            Minecraft.m_91087_().m_91152_(null);
        } else {
            Minecraft.m_91087_().m_91152_((Screen)new DialogMessageScreen(bound));
        }
        return null;
    }

    public static Object cameraForce(CameraForceBound cameraForceBound, Supplier<NetworkEvent.Context> contextSupplier) {
        CutSceneManagement.setPositionForce(cameraForceBound.getPos());
        return null;
    }

    public static Object cameraTrans(CameraTransitionBound cameraTransitionBound, Supplier<NetworkEvent.Context> contextSupplier) {
        CutSceneManagement.setTransitionGoal(cameraTransitionBound.getGoal());
        CutSceneManagement.setTransition(new Bi<CameraPos, CameraPos>(cameraTransitionBound.getPos1(), cameraTransitionBound.getPos2()));
        return null;
    }

    public static Object notification(Notification notification, Supplier<NetworkEvent.Context> contextSupplier) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.PERIODIC_NOTIFICATION, notification.title(), notification.text()));
        return null;
    }
}

