/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iorace;

import com.interordi.iorace.IORace;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class DeathListener
implements Listener {
    private IORace plugin;
    private char targetAxis;
    private char targetDirection;
    private boolean announceDeaths = false;
    private boolean useIOChatBridge = false;

    public DeathListener(IORace plugin, char targetAxis, char targetDirection) {
        this.plugin = plugin;
        this.targetAxis = targetAxis;
        this.targetDirection = targetDirection;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player p = event.getEntity();
        if (p.getGameMode() == GameMode.SURVIVAL || p.getGameMode() == GameMode.ADVENTURE) {
            Location lastLocation = p.getLocation();
            int lastCoord = 0;
            lastCoord = this.targetAxis == 'x' ? lastLocation.getBlockX() : (this.targetAxis == 'y' ? lastLocation.getBlockY() : lastLocation.getBlockZ());
            this.plugin.thisPlayerWatcher.recordDeath(p, lastCoord);
            this.plugin.thisPlayerWatcher.updateScore(p, true);
            if (this.announceDeaths) {
                String message = "Player " + p.getName() + " has fallen after " + String.format(Locale.US, "%,d", lastCoord) + " metres!";
                if (this.useIOChatBridge) {
                    this.plugin.getLogger().info("|IOBC|" + message);
                } else {
                    Bukkit.getServer().broadcastMessage(message);
                }
            }
        }
        EntityDamageEvent entityDamageCause = p.getLastDamageCause();
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        final Player p = event.getPlayer();
        this.plugin.getLogger().info("Respawning " + p.getName());
        final World w = (World)Bukkit.getServer().getWorlds().get(0);
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                p.teleport(w.getSpawnLocation());
            }
        }, 10L);
    }

    public void setAnnounceDeaths(boolean value, boolean useIOChatBridge) {
        this.announceDeaths = value;
        this.useIOChatBridge = useIOChatBridge;
    }
}

