/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iorace;

import com.interordi.iorace.DeathListener;
import com.interordi.iorace.PlayerWatcher;
import com.interordi.iorace.bstats.bukkit.Metrics;
import com.interordi.iorace.utilities.Scores;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class IORace
extends JavaPlugin {
    public DeathListener thisDeathListener;
    public PlayerWatcher thisPlayerWatcher;
    Scores thisScores;

    public void onEnable() {
        this.saveDefaultConfig();
        boolean announceDeaths = this.getConfig().getBoolean("announce-deaths");
        int updateInterval = this.getConfig().getInt("update-interval", 500);
        int announceInterval = this.getConfig().getInt("announce-interval", 5000);
        boolean useIOChatBridge = this.getConfig().getBoolean("use-iochatbridge", false);
        char targetAxis = this.getConfig().getString("target-axis", "x").toLowerCase().charAt(0);
        char targetDirection = this.getConfig().getString("target-direction", "+").toLowerCase().charAt(0);
        if (targetDirection == 'p') {
            targetDirection = '+';
        } else if (targetDirection == 'm') {
            targetDirection = '-';
        }
        this.getLogger().info("Target: " + targetAxis + targetDirection);
        this.thisScores = new Scores("Position", targetAxis, targetDirection);
        this.thisDeathListener = new DeathListener(this, targetAxis, targetDirection);
        this.thisDeathListener.setAnnounceDeaths(announceDeaths, useIOChatBridge);
        this.thisPlayerWatcher = new PlayerWatcher(this, targetAxis, targetDirection);
        this.thisPlayerWatcher.setUpdates(updateInterval, announceInterval, announceDeaths, useIOChatBridge);
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)this.thisPlayerWatcher, 100L, 100L);
        Metrics metrics = new Metrics(this, 27499);
        this.getLogger().info("IORace enabled");
    }

    public void onDisable() {
        this.getLogger().info("IORace disabled");
    }

    public String getPosition(Player p) {
        return this.thisPlayerWatcher.getPosition(p);
    }

    public Scores getScores() {
        return this.thisScores;
    }

    public String colorize(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }
}

