/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iorace;

import com.interordi.iorace.IORace;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerWatcher
implements Runnable {
    private IORace plugin;
    private char targetAxis;
    private char targetDirection;
    private String filePath = "plugins/IORace/positions.yml";
    private Map<UUID, Integer> posPlayers = new HashMap<UUID, Integer>();
    private Map<UUID, Integer> posDeaths = new HashMap<UUID, Integer>();
    private boolean announceDeaths = false;
    private int updateInterval = 500;
    private int announceInterval = 5000;
    private boolean useIOChatBridge = false;

    public PlayerWatcher(IORace plugin, char targetAxis, char targetDirection) {
        this.plugin = plugin;
        this.targetAxis = targetAxis;
        this.targetDirection = targetDirection;
        this.loadPositions();
    }

    public void loadPositions() {
        String pos;
        UUID uuid;
        Set cs;
        File statsFile = new File(this.filePath);
        try {
            if (!statsFile.exists()) {
                statsFile.createNewFile();
            }
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("Failed to create the positions file");
            e.printStackTrace();
            return;
        }
        YamlConfiguration statsAccess = YamlConfiguration.loadConfiguration((File)statsFile);
        ConfigurationSection posData = statsAccess.getConfigurationSection("positions");
        if (posData != null && (cs = posData.getKeys(false)) != null) {
            for (String temp : cs) {
                uuid = UUID.fromString(temp);
                pos = posData.getString(temp);
                this.posPlayers.put(uuid, Integer.parseInt(pos));
            }
        }
        if ((posData = statsAccess.getConfigurationSection("deaths")) != null && (cs = posData.getKeys(false)) != null) {
            for (String temp : cs) {
                uuid = UUID.fromString(temp);
                pos = posData.getString(temp);
                this.posDeaths.put(uuid, Integer.parseInt(pos));
            }
        }
        this.loadScores();
    }

    public void savePositions() {
        int position;
        UUID uuid;
        File statsFile = new File(this.filePath);
        YamlConfiguration statsAccess = YamlConfiguration.loadConfiguration((File)statsFile);
        statsAccess.set("positions", (Object)"");
        for (Map.Entry<UUID, Integer> entry : this.posPlayers.entrySet()) {
            uuid = entry.getKey();
            position = entry.getValue();
            statsAccess.set("positions." + uuid, (Object)position);
        }
        statsAccess.set("deaths", (Object)"");
        for (Map.Entry<UUID, Integer> entry : this.posDeaths.entrySet()) {
            uuid = entry.getKey();
            position = entry.getValue();
            statsAccess.set("deaths." + uuid, (Object)position);
        }
        try {
            statsAccess.save(statsFile);
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("Failed to save the player positions.");
            e.printStackTrace();
        }
    }

    public void setPosPlayer(Player p, int coord) {
        this.posPlayers.put(p.getUniqueId(), coord);
        this.savePositions();
    }

    public void recordDeath(Player p, int coord) {
        if (!this.posDeaths.containsKey(p.getUniqueId()) || this.targetDirection == '+' && coord > this.posDeaths.get(p.getUniqueId()) || this.targetDirection == '-' && coord < this.posDeaths.get(p.getUniqueId())) {
            this.posDeaths.put(p.getUniqueId(), coord);
            this.checkStatus(p);
            this.savePositions();
        }
    }

    public void setUpdates(int updates, int announces, boolean deaths, boolean useIOChatBridge) {
        this.updateInterval = updates;
        this.announceInterval = announces;
        this.announceDeaths = deaths;
        this.useIOChatBridge = useIOChatBridge;
    }

    public boolean checkStatus(Player p) {
        if (p.getGameMode() != GameMode.SURVIVAL && p.getGameMode() != GameMode.ADVENTURE) {
            return false;
        }
        Location newLocation = p.getLocation();
        int currentPos = 0;
        currentPos = this.targetAxis == 'x' ? newLocation.getBlockX() : (this.targetAxis == 'y' ? newLocation.getBlockY() : newLocation.getBlockZ());
        Integer oldPos = this.posPlayers.get(p.getUniqueId());
        if (oldPos == null || this.targetDirection == '+' && currentPos > oldPos || this.targetDirection == '-' && currentPos < oldPos) {
            if (oldPos == null) {
                oldPos = 0;
            }
            this.posPlayers.put(p.getUniqueId(), currentPos);
            Integer deathPos = this.posDeaths.get(p.getUniqueId());
            if (deathPos == null || this.targetDirection == '+' && deathPos < currentPos || this.targetDirection == '-' && deathPos > currentPos) {
                this.updateScore(p, false);
            }
            if (this.targetDirection == '+' && currentPos / this.announceInterval > oldPos / this.announceInterval || this.targetDirection == '-' && currentPos / this.announceInterval < oldPos / this.announceInterval) {
                int announce = currentPos / this.announceInterval * this.announceInterval;
                String message = "Player " + p.getName() + " has passed the " + String.format(Locale.US, "%,d", announce) + " metres mark!";
                if (this.useIOChatBridge) {
                    this.plugin.getLogger().info("|IOBC|" + message);
                } else {
                    Bukkit.getServer().broadcastMessage(message);
                }
            }
            return true;
        }
        return false;
    }

    public String getPosition(Player p) {
        Integer pos = this.posPlayers.get(p.getUniqueId());
        if (pos == null) {
            pos = 0;
        }
        return String.format(Locale.US, "%,d", pos);
    }

    @Override
    public void run() {
        boolean updates = false;
        for (Player p : Bukkit.getOnlinePlayers()) {
            updates |= this.checkStatus(p);
        }
        if (updates) {
            this.savePositions();
        }
    }

    public void updateScore(Player player, boolean death) {
        int score = this.posPlayers.get(player.getUniqueId());
        if (!death) {
            score = score / this.updateInterval * this.updateInterval;
        }
        this.plugin.getScores().updateScore(player, score);
    }

    public void loadScores() {
        HashMap<UUID, Integer> scores = new HashMap<UUID, Integer>();
        for (UUID key : this.posPlayers.keySet()) {
            int display = 0;
            display = this.posDeaths.containsKey(key) && (this.targetDirection == '+' && this.posDeaths.get(key) >= this.posPlayers.get(key) || this.targetDirection == '-' && this.posDeaths.get(key) < this.posPlayers.get(key)) ? this.posDeaths.get(key) : this.posPlayers.get(key) / this.updateInterval * this.updateInterval;
            scores.put(key, display);
        }
        this.plugin.getScores().loadScores(scores);
    }
}

