/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iorace.utilities;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;

public class Scores {
    private String header;
    private char targetAxis;
    private char targetDirection;
    private Map<UUID, Integer> scoresPlayers = new HashMap<UUID, Integer>();

    public Scores(String header, char targetAxis, char targetDirection) {
        this.header = header;
        this.targetAxis = targetAxis;
        this.targetDirection = targetDirection;
    }

    public void refreshDisplay() {
        Scoreboard board = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective objective = board.getObjective("score");
        board.clearSlot(DisplaySlot.SIDEBAR);
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        Map topThree = null;
        topThree = this.targetDirection == '+' ? (Map)this.scoresPlayers.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(3L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)) : (Map)this.scoresPlayers.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.naturalOrder())).limit(3L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        HashSet<UUID> toDisplay = new HashSet<UUID>();
        for (UUID topPlayer : topThree.keySet()) {
            toDisplay.add(topPlayer);
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            toDisplay.add(p.getUniqueId());
        }
        for (UUID uuid : toDisplay) {
            OfflinePlayer offPlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            String playerName = offPlayer.getName();
            if (playerName.isEmpty()) continue;
            Score myScore = objective.getScore(playerName);
            if (!this.scoresPlayers.containsKey(uuid)) continue;
            int display = this.scoresPlayers.get(uuid);
            if ((this.targetDirection != '+' || display <= 0) && (this.targetDirection != '-' || display >= 0)) continue;
            myScore.setScore(display);
        }
    }

    public void updateScore(Player player, int score) {
        Scoreboard board = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective objective = board.getObjective("score");
        if (objective != null) {
            Score myScore = objective.getScore(player.getDisplayName());
            myScore.setScore(score);
        } else {
            Bukkit.getLogger().severe("No objective found!!");
        }
        this.scoresPlayers.put(player.getUniqueId(), score);
        this.refreshDisplay();
    }

    public void loadScores(Map<UUID, Integer> scores) {
        Scoreboard board = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective objective = board.getObjective("score");
        if (objective != null) {
            objective.unregister();
            objective = null;
        }
        this.scoresPlayers = scores;
        objective = board.registerNewObjective("score", "dummy", this.header);
        this.refreshDisplay();
    }
}

