/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.remoteresourcepack.forge;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import xland.mcmod.remoteresourcepack.forge.NeoMigrationCandidate;

public class NeoMigrationPlugin
implements IMixinConfigPlugin {
    private static final Collection<String> patchedMethodCandidate = Set.of("m_295067_", "addInitialScreens");

    private static InsnList injectedList() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "xland/mcmod/remoteresourcepack/forge/NeoMigrationHooks", "addWarningScreen", "(Ljava/util/List;)V", true));
        return list;
    }

    private static void applyMigration(ClassNode classNode) {
        classNode.methods.stream().filter(m -> patchedMethodCandidate.contains(m.name)).forEach(method -> {
            for (AbstractInsnNode ins : method.instructions) {
                switch (ins.getOpcode()) {
                    case 172: 
                    case 177: {
                        method.instructions.insertBefore(ins, NeoMigrationPlugin.injectedList());
                    }
                }
            }
        });
    }

    public void onLoad(String s) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String s, String s1) {
        return true;
    }

    public void acceptTargets(Set<String> set, Set<String> set1) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }

    public void postApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
        if (classNode.invisibleAnnotations == null) {
            return;
        }
        if (classNode.invisibleAnnotations.stream().anyMatch(a -> Type.getDescriptor(NeoMigrationCandidate.class).equals(a.desc))) {
            NeoMigrationPlugin.applyMigration(classNode);
        }
    }
}

