/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.remoteresourcepack;

import com.google.common.hash.Hashing;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.StringCharacterIterator;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import net.minecraft.class_3518;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import xland.mcmod.remoteresourcepack.RemoteResourcePack;
import xland.mcmod.remoteresourcepack.ZipConfigDownload;

public final class HashableSingleSource {
    final URI baseUri;
    final URI zipConfigUri;
    final Duration autoUpdate;
    final Map<String, String> args;
    private static final byte schemaVersion = 1;
    private final transient String hash;
    private static final Map<String, Long> DURATION_UNITS = Map.of("ms", 1L, "s", 1000L, "sec", 1000L, "m", 60000L, "mi", 60000L, "min", 60000L, "h", 3600000L, "hr", 3600000L, "d", 86400000L);

    HashableSingleSource(URI baseUri, URI zipConfigUri, Duration autoUpdate, Map<String, String> args) {
        this.baseUri = baseUri;
        this.zipConfigUri = zipConfigUri;
        this.autoUpdate = autoUpdate;
        this.args = args;
        this.hash = this.internalCalcSha256();
    }

    public boolean exists(Path repo) {
        return Files.exists(this.getStoreCacheFile(repo), new LinkOption[0]);
    }

    public boolean isOutdated(Path repo) {
        boolean bl;
        if (!this.exists(repo)) {
            return true;
        }
        if (HashableSingleSource.isAlwaysUpToDate(this.autoUpdate)) {
            return false;
        }
        Path timestamp = this.getStoreCacheTimestampFile(repo);
        if (Files.notExists(timestamp, new LinkOption[0])) {
            return true;
        }
        DataInputStream input = new DataInputStream(Files.newInputStream(timestamp, new OpenOption[0]));
        try {
            Instant instant = HashableSingleSource.readInstant(input);
            bl = instant.plus(this.autoUpdate).isBefore(Instant.now());
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                RemoteResourcePack.LOGGER.error("Can't read timestamp file {}", (Object)timestamp, (Object)e);
                return true;
            }
        }
        input.close();
        return bl;
    }

    public Path generate(Path repo) throws IOException, CompletionException {
        Path file = this.getStoreCacheFile(repo);
        if (!this.isOutdated(repo)) {
            return file;
        }
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        ZipConfigDownload.generateZip(this.readZipConfig(), this.baseUri, this.args, file);
        Path timestamp = this.getStoreCacheTimestampFile(repo);
        try (DataOutputStream output = new DataOutputStream(Files.newOutputStream(timestamp, new OpenOption[0]));){
            HashableSingleSource.writeInstant(output, Instant.now());
        }
        return file;
    }

    private JsonObject readZipConfig() throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.zipConfigUri.toURL().openStream()));){
            JsonObject jsonObject = class_3518.method_15255((Reader)reader);
            return jsonObject;
        }
    }

    private static boolean isAlwaysUpToDate(Duration duration) {
        return duration.isNegative();
    }

    public String getHash() {
        return this.hash;
    }

    private StringBuilder getSlicedHash() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.hash, 0, 2).append('/');
        sb.append(this.hash, 2, 32).append('/');
        sb.append(this.hash, 33, 64);
        return sb;
    }

    public Path getStoreCacheFile(Path repo) {
        return repo.resolve(this.getSlicedHash().append(".zip").toString());
    }

    public Path getStoreCacheTimestampFile(Path repo) {
        return repo.resolve(this.getSlicedHash().append(".timestamp").toString());
    }

    public static HashableSingleSource of(URI baseUri, URI zipConfigUri, Duration autoUpdate, Map<String, String> args) {
        autoUpdate = HashableSingleSource.canonicalizeDuration(autoUpdate);
        return new HashableSingleSource(baseUri, zipConfigUri, autoUpdate, args);
    }

    public static HashableSingleSource readFromJson(JsonObject obj) throws JsonParseException {
        String autoUpdateExpr;
        URI zipConfigUri;
        URI baseUri;
        if (class_3518.method_15271((JsonObject)obj, (String)"schema", (byte)0) != 1) {
            throw new JsonParseException((Throwable)HashableSingleSource.schemaMismatch(obj.get("schema").getAsByte()));
        }
        try {
            baseUri = URI.create(class_3518.method_15265((JsonObject)obj, (String)"base"));
            zipConfigUri = URI.create(class_3518.method_15265((JsonObject)obj, (String)"zipconfig"));
        }
        catch (IllegalArgumentException e2) {
            throw new JsonParseException("Unresolvable URI", (Throwable)e2);
        }
        Duration autoUpdate = switch (autoUpdateExpr = class_3518.method_15253((JsonObject)obj, (String)"autoUpdate", (String)"2d")) {
            case "always", "0" -> Duration.ZERO;
            case "never", "-1" -> Duration.ofSeconds(-1L);
            default -> HashableSingleSource.durationFromString(autoUpdateExpr);
        };
        obj = class_3518.method_15281((JsonObject)obj, (String)"args", (JsonObject)new JsonObject());
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        obj.entrySet().forEach(e -> {
            if (!((JsonElement)e.getValue()).isJsonPrimitive()) {
                throw new JsonParseException(String.format("Expect argument %s to be primitive, got %s", e.getKey(), e.getValue()));
            }
            args.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
        });
        return HashableSingleSource.of(baseUri, zipConfigUri, autoUpdate, args);
    }

    private static IOException schemaMismatch(int b) {
        return new InvalidObjectException(String.format("Invalid schema version: expected %d, got %d", (byte)1, b));
    }

    private static Duration canonicalizeDuration(Duration old) {
        if (old.isNegative()) {
            return Duration.ofSeconds(-1L);
        }
        return old;
    }

    private static void writeDuration(DataOutput output, Duration duration) throws IOException {
        output.writeLong(duration.getSeconds());
        output.writeInt(duration.getNano());
    }

    private static Instant readInstant(DataInput input) throws IOException {
        long sec = input.readLong();
        int nanos = input.readInt();
        return Instant.ofEpochSecond(sec, nanos);
    }

    private static void writeInstant(DataOutput output, Instant instant) throws IOException {
        output.writeLong(instant.getEpochSecond());
        output.writeInt(instant.getNano());
    }

    public void dumpsToBinary(DataOutput output) throws IOException {
        output.writeByte(1);
        output.writeUTF(this.baseUri.toString());
        output.writeUTF(this.zipConfigUri.toString());
        HashableSingleSource.writeDuration(output, this.autoUpdate);
        HashableSingleSource.writeMap(output, this.args);
    }

    private static void writeMap(DataOutput output, Map<String, String> args) throws IOException {
        output.writeInt(args.size());
        try {
            args.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> {
                try {
                    output.writeUTF((String)e.getKey());
                    output.writeUTF((String)e.getValue());
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
        }
        catch (UncheckedIOException e2) {
            throw e2.getCause();
        }
    }

    public byte[] toBytes() {
        ByteArrayOutputStream os = new ByteArrayOutputStream(128);
        try {
            this.dumpsToBinary(new DataOutputStream(os));
        }
        catch (IOException e) {
            throw new AssertionError("Will not happen", e);
        }
        return os.toByteArray();
    }

    private String internalCalcSha256() {
        return Hashing.sha256().hashBytes(this.toBytes()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashableSingleSource that = (HashableSingleSource)o;
        return new EqualsBuilder().append((Object)this.baseUri, (Object)that.baseUri).append((Object)this.zipConfigUri, (Object)that.zipConfigUri).append((Object)this.autoUpdate, (Object)that.autoUpdate).append(this.args, that.args).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.baseUri).append((Object)this.zipConfigUri).append((Object)this.autoUpdate).append(this.args).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("baseUri", (Object)this.baseUri).append("zipConfigUri", (Object)this.zipConfigUri).append("autoUpdate", (Object)this.autoUpdate).append("args", this.args).toString();
    }

    private static Duration durationFromString(String s) {
        StringCharacterIterator itr = new StringCharacterIterator(s);
        ArrayList<Map.Entry<String, Object>> list = new ArrayList<Map.Entry<String, Object>>();
        int start = 0;
        Integer integer = null;
        while (true) {
            char c;
            if ("0123456789".indexOf(c = itr.next()) >= 0) {
                if (integer == null) continue;
                int n = start;
                start = itr.getIndex();
                list.add(Map.entry(s.substring(n, start), integer));
                integer = null;
                continue;
            }
            if (c == '\uffff') {
                if (integer == null) {
                    list.add(Map.entry("s", Integer.parseInt(s, start, itr.getEndIndex(), 10)));
                    break;
                }
                list.add(Map.entry(s.substring(start, itr.getEndIndex()), integer));
                break;
            }
            if (integer != null) continue;
            int n = start;
            start = itr.getIndex();
            integer = Integer.parseInt(s, n, start, 10);
        }
        return Duration.ofMillis(list.stream().mapToLong(e -> Objects.requireNonNull(DURATION_UNITS.get(e.getKey()), e::getKey) * (long)((Integer)e.getValue()).intValue()).sum());
    }
}

