/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.remoteresourcepack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_3518;
import net.minecraft.obfuscate.DontObfuscate;
import org.apache.commons.io.function.IOSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import xland.mcmod.remoteresourcepack.HashableSingleSource;
import xland.mcmod.remoteresourcepack.fabric.RemoteResourcePackImpl;

public abstract class RemoteResourcePack {
    public static final String MOD_ID = "remoteresourcepack";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER = MarkerManager.getMarker((String)"RemoteResourcePack");
    private static volatile Map<String, Path> cacheFiles;

    public static String packName(String key) {
        return "RemoteResourcePack/" + key;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RemoteResourcePack platform() {
        return RemoteResourcePackImpl.platform();
    }

    @DontObfuscate
    public static void init() {
        Path repo = RemoteResourcePack.platform().getGameDir().resolve("RemoteResourcePack");
        LOGGER.info(MARKER, "Scanning builtin mod config");
        Map<String, IOSupplier<BufferedReader>> modsBuiltinConfigs = RemoteResourcePack.platform().getModsBuiltinConfigs();
        try {
            cacheFiles = Collections.unmodifiableMap(RemoteResourcePack.cache(modsBuiltinConfigs, repo));
        }
        catch (IOException e) {
            LOGGER.error("Failed to download/generate remote resource pack(s)", (Throwable)e);
        }
    }

    public static Map<String, Path> getCacheFiles() {
        Map<String, Path> map = cacheFiles;
        if (map == null) {
            throw new IllegalStateException("cacheFiles not initialized yet");
        }
        return map;
    }

    protected abstract Path getGameDir();

    private static int getConfigVersion(JsonObject obj) {
        JsonElement configVersionElement = obj.get("configVersion");
        if (configVersionElement == null || !configVersionElement.isJsonPrimitive() || !configVersionElement.getAsJsonPrimitive().isNumber()) {
            return -1;
        }
        return configVersionElement.getAsJsonPrimitive().getAsInt();
    }

    private static void extractModConfig(Map<String, IOSupplier<BufferedReader>> source, Path dest) throws IOException {
        LinkedHashMap<String, JsonObject> toBeWritten = new LinkedHashMap<String, JsonObject>();
        HashMap<String, Integer> configVersions = new HashMap<String, Integer>();
        LinkedHashMap<String, String> path2modCache = new LinkedHashMap<String, String>();
        for (Map.Entry<String, IOSupplier<BufferedReader>> confFileEntry : source.entrySet()) {
            JsonObject conf;
            try (BufferedReader reader = (BufferedReader)confFileEntry.getValue().get();){
                conf = class_3518.method_15255((Reader)reader);
            }
            for (Map.Entry e : conf.entrySet()) {
                if (!((JsonElement)e.getValue()).isJsonObject()) {
                    throw new JsonParseException(String.format("Expect %s (from mod %s) to be object, got %s", e.getKey(), confFileEntry.getKey(), e.getValue()));
                }
                path2modCache.merge((String)e.getKey(), confFileEntry.getKey(), (mod1, mod2) -> {
                    throw new JsonParseException(String.format("Duplicate definition of %s (from mod %s and %s)", e.getKey(), mod1, mod2));
                });
                JsonObject obj = ((JsonElement)e.getValue()).getAsJsonObject();
                int configVersion = RemoteResourcePack.getConfigVersion(obj);
                configVersions.put((String)e.getKey(), configVersion);
                toBeWritten.put((String)e.getKey(), obj);
            }
        }
        LOGGER.info(MARKER, "Dumping builtin configs");
        for (Map.Entry filename2json : toBeWritten.entrySet()) {
            Path configFile = dest.resolve((String)filename2json.getKey()).toAbsolutePath().normalize();
            if (Files.exists(configFile, new LinkOption[0])) {
                try {
                    BufferedReader reader = Files.newBufferedReader(configFile);
                    try {
                        JsonObject obj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        int localConfigVersion = RemoteResourcePack.getConfigVersion(obj);
                        int givenConfigVersion = configVersions.getOrDefault(filename2json.getKey(), -1);
                        if (givenConfigVersion <= localConfigVersion) {
                            continue;
                        }
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                        continue;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Can't read config at {}. Force override.", (Object)configFile);
                }
            }
            boolean isSub = false;
            for (Path dynPath = configFile; dynPath != null; dynPath = dynPath.getParent()) {
                if (!dynPath.equals(dest)) continue;
                isSub = true;
                break;
            }
            if (!isSub) {
                throw new AccessDeniedException((String)filename2json.getKey() + " escapes out of config dir");
            }
            Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);
            try {
                GSON.toJson((JsonElement)filename2json.getValue(), (Appendable)writer);
            }
            finally {
                if (writer == null) continue;
                writer.close();
            }
        }
    }

    static Map<String, Path> cache(Map<String, IOSupplier<BufferedReader>> modConfigs, Path repo) throws IOException, JsonParseException {
        LOGGER.info(MARKER, "Loading config");
        Path modConfigDir = RemoteResourcePack.getModConfigDir().toAbsolutePath().normalize();
        Files.createDirectories(modConfigDir, new FileAttribute[0]);
        RemoteResourcePack.extractModConfig(modConfigs, modConfigDir);
        LOGGER.info("Downloading + generating files");
        ConcurrentHashMap<String, Path> cacheFilesPerHash = new ConcurrentHashMap<String, Path>();
        try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
            CopyOnWriteArrayList futures = new CopyOnWriteArrayList();
            AtomicInteger cc = new AtomicInteger();
            try (Stream<Path> stream = Files.walk(modConfigDir, new FileVisitOption[0]);){
                stream.forEach(path -> {
                    if (!Files.isRegularFile(path, new LinkOption[0]) || !path.toString().endsWith(".json")) {
                        return;
                    }
                    futures.add(CompletableFuture.runAsync(() -> {
                        JsonObject singleConfig;
                        LOGGER.info("(#{}) Generating pack from {}", (Object)cc.incrementAndGet(), path);
                        try (BufferedReader reader = Files.newBufferedReader(path);){
                            singleConfig = class_3518.method_15255((Reader)reader);
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to parse config from {}", path);
                            return;
                        }
                        try {
                            HashableSingleSource source = HashableSingleSource.readFromJson(singleConfig);
                            cacheFilesPerHash.put(source.getHash(), source.generate(repo));
                            LOGGER.info("Generated pack {} from {}", (Object)source.getHash(), path);
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to parse config or generate pack from {}", path, (Object)e);
                        }
                    }, executor));
                });
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        }
        return cacheFilesPerHash;
    }

    static Path getModConfigDir() {
        return RemoteResourcePack.platform().getConfigDir().resolve("RemoteResourcePack");
    }

    protected abstract Path getConfigDir();

    protected abstract Map<String, IOSupplier<BufferedReader>> getModsBuiltinConfigs();

    protected abstract String modVersion();

    protected abstract String minecraftVersion();

    public static void insertEnabledPacks(class_3283 packRepository) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        List<String> remotePackNames = RemoteResourcePack.getCacheFiles().keySet().stream().map(RemoteResourcePack::packName).toList();
        if (remotePackNames.isEmpty()) {
            return;
        }
        set.addAll(packRepository.method_29210());
        set.addAll(remotePackNames);
        packRepository.method_14447(set);
        List optionsResourcePacks = class_310.method_1551().field_1690.field_1887;
        remotePackNames.forEach(s -> {
            if (!optionsResourcePacks.contains(s)) {
                optionsResourcePacks.add(s);
            }
        });
    }
}

