/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.remoteresourcepack.fabric;

import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3283;
import org.apache.commons.io.function.IOSupplier;
import xland.mcmod.remoteresourcepack.RRPCacheRepoSource;
import xland.mcmod.remoteresourcepack.RemoteResourcePack;
import xland.mcmod.remoteresourcepack.fabric.MutablePackRepository;

public final class RemoteResourcePackImpl
extends RemoteResourcePack {
    private static final RemoteResourcePackImpl INSTANCE = new RemoteResourcePackImpl();

    public static void init() {
        RemoteResourcePack.init();
    }

    @Override
    protected Path getGameDir() {
        return FabricLoader.getInstance().getGameDir().toAbsolutePath().normalize();
    }

    @Override
    protected Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir().toAbsolutePath().normalize();
    }

    @Override
    protected Map<String, IOSupplier<BufferedReader>> getModsBuiltinConfigs() {
        return FabricLoader.getInstance().getAllMods().stream().flatMap(c -> c.findPath("RemoteResourcePack.json").stream().map(p -> Map.entry(c.getMetadata().getId(), () -> Files.newBufferedReader(p)))).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static String getModVersion(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(modContainer -> modContainer.getMetadata().getVersion().getFriendlyString()).orElseThrow(() -> new RuntimeException("Can't find " + modId + " mod?!"));
    }

    @Override
    protected String modVersion() {
        return RemoteResourcePackImpl.getModVersion("remoteresourcepack");
    }

    public static void addPackSource(class_3283 packRepository) {
        ((MutablePackRepository)packRepository).remoteResourcePack$addRepoSource(new RRPCacheRepoSource(RemoteResourcePack.getCacheFiles()));
    }

    @Override
    protected String minecraftVersion() {
        return RemoteResourcePackImpl.getModVersion("minecraft");
    }

    public static RemoteResourcePack platform() {
        return INSTANCE;
    }
}

