/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.remoteresourcepack;

import com.google.common.base.Suppliers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.random.RandomGenerator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.util.GsonHelper;
import xland.mcmod.remoteresourcepack.RRPCacheRepoSource;
import xland.mcmod.remoteresourcepack.RemoteResourcePack;

final class ZipConfigDownload
implements Closeable {
    private static final Base64.Decoder B64DECODER = Base64.getDecoder();
    private static final ThreadLocal<RandomGenerator> RANDOM = ThreadLocal.withInitial(Random::new);
    private static final String SKIP_KEY = "mod";
    private static final String PACK_MCMETA = "pack.mcmeta";
    private static final Duration TIMEOUT = Duration.ofSeconds(10L);
    private final ZipOutputStream zos;
    private final ExecutorService executor;
    private final HttpClient httpClient;
    private final URI baseUri;
    private final List<CompletableFuture<?>> futures;
    private static final Supplier<String> USER_AGENT = Suppliers.memoize(() -> "RemoteResourcePack/" + RemoteResourcePack.platform().modVersion() + " MC/" + RemoteResourcePack.platform().minecraftVersion() + " (Platform:" + ClientBrandRetriever.getClientModName() + ")");

    private ZipConfigDownload(ZipOutputStream zos, URI baseUri) {
        this.zos = zos;
        this.baseUri = baseUri;
        this.executor = Executors.newSingleThreadExecutor();
        this.httpClient = HttpClient.newBuilder().connectTimeout(TIMEOUT).followRedirects(HttpClient.Redirect.NORMAL).executor(Executors.newVirtualThreadPerTaskExecutor()).build();
        this.futures = new CopyOnWriteArrayList();
    }

    @Override
    public void close() throws IOException {
        this.executor.close();
        this.httpClient.close();
        this.futures.clear();
        this.zos.close();
    }

    private static boolean isStatusOk(int statusCode) {
        return statusCode >= 200 && statusCode <= 299;
    }

    private void addFileToZip(String filename, JsonObject data) throws IllegalArgumentException {
        CompletionStage putEntryFuture;
        if (ZipConfigDownload.shouldSkip(data)) {
            return;
        }
        ZipEntry zipEntry = new ZipEntry(filename);
        CompletionStage<Object> fetchBytesFuture = null;
        if (!filename.endsWith("/")) {
            if (GsonHelper.isStringValue((JsonObject)data, (String)"fetch")) {
                String s = GsonHelper.getAsString((JsonObject)data, (String)"fetch");
                URI uri = this.baseUri.resolve(s);
                fetchBytesFuture = this.httpClient.sendAsync(HttpRequest.newBuilder(uri).GET().header("User-Agent", USER_AGENT.get()).build(), HttpResponse.BodyHandlers.ofByteArray()).thenCompose(httpResponse -> {
                    if (ZipConfigDownload.isStatusOk(httpResponse.statusCode())) {
                        return CompletableFuture.completedStage((byte[])httpResponse.body());
                    }
                    return CompletableFuture.failedStage(new IOException("Failed to GET " + String.valueOf(uri) + ": status code returned " + httpResponse.statusCode()));
                });
            } else if (GsonHelper.isStringValue((JsonObject)data, (String)"base64")) {
                byte[] b = B64DECODER.decode(GsonHelper.getAsString((JsonObject)data, (String)"base64"));
                fetchBytesFuture = CompletableFuture.completedFuture(b);
            } else if (GsonHelper.isStringValue((JsonObject)data, (String)"raw")) {
                byte[] b = GsonHelper.getAsString((JsonObject)data, (String)"raw").getBytes(StandardCharsets.UTF_8);
                fetchBytesFuture = CompletableFuture.completedFuture(b);
            }
        }
        if (fetchBytesFuture != null) {
            if (PACK_MCMETA.equals(filename)) {
                fetchBytesFuture = fetchBytesFuture.thenApply(RRPCacheRepoSource::modifyPackMcmeta);
            }
            putEntryFuture = fetchBytesFuture.thenComposeAsync(bytes -> {
                try {
                    this.zos.putNextEntry(zipEntry);
                    this.zos.write((byte[])bytes);
                    this.zos.closeEntry();
                    return CompletableFuture.completedStage(null);
                }
                catch (IOException e) {
                    return CompletableFuture.failedStage(e);
                }
            }, (Executor)this.executor);
        } else {
            putEntryFuture = new CompletableFuture().thenComposeAsync(v -> {
                try {
                    this.zos.putNextEntry(zipEntry);
                    this.zos.closeEntry();
                    return CompletableFuture.completedStage(null);
                }
                catch (IOException e) {
                    return CompletableFuture.failedStage(e);
                }
            }, (Executor)this.executor);
        }
        this.futures.add((CompletableFuture<?>)putEntryFuture);
    }

    private static boolean shouldSkip(JsonObject data) {
        JsonElement e = data.get("skip_on");
        if (e == null) {
            return false;
        }
        if (GsonHelper.isStringValue((JsonElement)e)) {
            return SKIP_KEY.equalsIgnoreCase(e.getAsString());
        }
        if (e.isJsonArray()) {
            for (JsonElement arrayElement : e.getAsJsonArray()) {
                if (!GsonHelper.isStringValue((JsonElement)arrayElement) || !SKIP_KEY.equalsIgnoreCase(arrayElement.getAsString())) continue;
                return true;
            }
        }
        return false;
    }

    static void generateZip(JsonObject zipConfig, URI baseUri, Map<String, String> args, Path dest) throws IOException, CompletionException {
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(dest, new OpenOption[0]));
             ZipConfigDownload zipConfigDownload = new ZipConfigDownload(zos, baseUri);){
            JsonObject staticFiles = GsonHelper.getAsJsonObject((JsonObject)zipConfig, (String)"static");
            for (Map.Entry entry : staticFiles.entrySet()) {
                zipConfigDownload.addFileToZip(entry);
            }
            JsonObject dynamicFiles = GsonHelper.getAsJsonObject((JsonObject)zipConfig, (String)"dynamic");
            block13: for (Map.Entry dynArgEntry : dynamicFiles.entrySet()) {
                int paramValue;
                JsonObject dynamicData = GsonHelper.convertToJsonObject((JsonElement)((JsonElement)dynArgEntry.getValue()), (String)((String)dynArgEntry.getKey()));
                String paramString = args.get(dynArgEntry.getKey());
                if ("random".equals(paramString)) {
                    paramValue = -1;
                } else {
                    try {
                        paramValue = Integer.parseUnsignedInt(paramString);
                    }
                    catch (NumberFormatException ex) {
                        JsonElement e = dynamicData.get("default");
                        if (e != null && e.isJsonPrimitive()) {
                            if ("random".equals(e.getAsString())) {
                                paramValue = -1;
                            } else {
                                paramValue = e.getAsJsonPrimitive().getAsInt();
                                if (paramValue < 0) {
                                    throw new JsonParseException("dynamic default value of %s is %s while negative value is illegal".formatted(dynArgEntry.getKey(), paramValue));
                                }
                            }
                        }
                        throw new JsonParseException("Missing default value for " + (String)dynArgEntry.getKey() + " or it is not primitive");
                    }
                }
                JsonArray items = GsonHelper.getAsJsonArray((JsonObject)dynamicData, (String)"items");
                if (paramValue < 0) {
                    String errDesc = "dynamic." + (String)dynArgEntry.getKey() + ".items";
                    int totalWeight = 0;
                    int index = 0;
                    int[] weights = new int[items.size()];
                    for (JsonElement item0 : items) {
                        JsonObject item = GsonHelper.convertToJsonObject((JsonElement)item0, (String)(errDesc + "." + index));
                        int weight = GsonHelper.getAsInt((JsonObject)item, (String)"weight", (int)100);
                        if (weight == 0) {
                            weight = 100;
                        }
                        int n = index++;
                        int n2 = weight;
                        weights[n] = n2;
                        totalWeight += n2;
                    }
                    int randomNum = RANDOM.get().nextInt(totalWeight);
                    index = 0;
                    for (JsonElement item0 : items) {
                        if ((randomNum -= weights[index++]) >= 0) continue;
                        JsonObject files = GsonHelper.getAsJsonObject((JsonObject)item0.getAsJsonObject(), (String)"files");
                        for (Map.Entry fileEntry : files.entrySet()) {
                            zipConfigDownload.addFileToZip(fileEntry);
                        }
                        continue block13;
                    }
                    continue;
                }
                if (paramValue >= items.size()) continue;
                JsonObject files = GsonHelper.getAsJsonObject((JsonObject)GsonHelper.convertToJsonObject((JsonElement)items.get(paramValue), (String)("dynamic." + (String)dynArgEntry.getKey() + ".items." + paramValue)), (String)"files");
                for (Map.Entry fileEntry : files.entrySet()) {
                    zipConfigDownload.addFileToZip(fileEntry);
                }
            }
            CompletableFuture.allOf(zipConfigDownload.futures.toArray(new CompletableFuture[0])).join();
        }
    }

    private void addFileToZip(Map.Entry<String, ? extends JsonElement> fileEntry) {
        this.addFileToZip(fileEntry.getKey(), GsonHelper.convertToJsonObject((JsonElement)fileEntry.getValue(), (String)fileEntry.getKey()));
    }
}

