/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.remoteresourcepack.neoforge;

import java.io.BufferedReader;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.neoforged.fml.ModList;
import net.neoforged.fml.jarcontents.JarResource;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.commons.io.function.IOSupplier;
import xland.mcmod.remoteresourcepack.RemoteResourcePack;
import xland.mcmod.remoteresourcepack.neoforge.RemoteResourcePackNeo;

public final class RemoteResourcePackImpl
extends RemoteResourcePack {
    private static final RemoteResourcePackImpl INSTANCE = new RemoteResourcePackImpl();

    @Override
    public Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public Map<String, IOSupplier<BufferedReader>> getModsBuiltinConfigs() {
        return ModList.get().applyForEachModFile(modFile -> Map.entry(((IModInfo)modFile.getModInfos().getFirst()).getModId(), Optional.ofNullable(modFile.getContents().get("RemoteResourcePack.json")))).flatMap(e -> ((Optional)e.getValue()).map(v -> Map.entry((String)e.getKey(), () -> ((JarResource)v).bufferedReader())).stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public String modVersion() {
        return Objects.requireNonNull(RemoteResourcePackNeo.modVersion, "modVersion uninitialized");
    }

    @Override
    public String minecraftVersion() {
        return Objects.requireNonNull(ModList.get().getModFileById("minecraft"), "Minecraft not found?!").versionString();
    }

    public static RemoteResourcePack platform() {
        return INSTANCE;
    }
}

