/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.remoteresourcepack;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import xland.mcmod.remoteresourcepack.RemoteResourcePack;

public class RRPCacheRepoSource
implements RepositorySource {
    private static final PackSource PACK_SOURCE = PackSource.create(packName -> Component.translatable((String)"pack.nameAndSource", (Object[])new Object[]{packName, Component.translatable((String)"pack.source.mod.remoteresourcepack")}).withStyle(ChatFormatting.GRAY), (boolean)true);
    private final Map<String, Path> knownCaches;
    private static final Gson GSON = new Gson();
    private static final String FORCE_COMPATIBLE = "remoteresourcepack:force_compatible";

    public RRPCacheRepoSource(Map<String, Path> knownCaches) {
        this.knownCaches = Collections.unmodifiableMap(knownCaches);
    }

    static byte[] modifyPackMcmeta(byte @NotNull [] b) {
        Objects.requireNonNull(b, "input bytes shall be non-null");
        try {
            return RRPCacheRepoSource.modifyPackMcmetaImpl(b);
        }
        catch (Exception e) {
            RemoteResourcePack.LOGGER.warn("Exception while trying to modifying a pack.mcmeta. Remaining unchanged.", (Throwable)e);
            return b;
        }
    }

    private static byte[] modifyPackMcmetaImpl(byte[] b) throws RuntimeException {
        String s = new String(b, StandardCharsets.UTF_8);
        JsonObject rootObj = (JsonObject)GSON.fromJson(s, JsonObject.class);
        if (!GsonHelper.getAsBoolean((JsonObject)rootObj, (String)FORCE_COMPATIBLE, (boolean)false)) {
            return b;
        }
        JsonObject packObj = GsonHelper.getAsJsonObject((JsonObject)rootObj, (String)"pack");
        JsonArray supportedFormats = new JsonArray();
        supportedFormats.add((Number)16);
        supportedFormats.add((Number)64);
        packObj.add("supported_formats", (JsonElement)supportedFormats);
        packObj.addProperty("pack_format", (Number)16);
        return rootObj.toString().getBytes(StandardCharsets.UTF_8);
    }

    public void loadPacks(@NotNull Consumer<Pack> consumer) {
        for (Map.Entry<String, Path> entry : this.knownCaches.entrySet()) {
            String packId = RemoteResourcePack.packName(entry.getKey());
            Path zipFile = entry.getValue();
            FilePackResources.FileResourcesSupplier resourcesSupplier = new FilePackResources.FileResourcesSupplier(RRPCacheRepoSource.getZipFile(zipFile));
            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo(packId, (Component)Component.translatable((String)"pack.source.mod.remoteresourcepack").append(" #").append(packId.substring(19, Math.min(packId.length(), 27))), PACK_SOURCE, Optional.empty()), (Pack.ResourcesSupplier)resourcesSupplier, (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(false, Pack.Position.TOP, false));
            Objects.requireNonNull(pack, () -> "Missing pack meta for " + packId);
            consumer.accept(pack);
        }
    }

    private static File getZipFile(Path zipFile) {
        try {
            return zipFile.toFile();
        }
        catch (UnsupportedOperationException e) {
            try {
                File file = File.createTempFile("RRPCache", ".zip");
                file.deleteOnExit();
                Files.copy(zipFile, file.toPath(), new CopyOption[0]);
                return file;
            }
            catch (IOException ex) {
                throw new UncheckedIOException("File " + String.valueOf(zipFile) + " (in filesystem " + String.valueOf(zipFile.getFileSystem()) + "), failed to copy to temp file", ex);
            }
        }
    }
}

