package xland.mcmod.remoteresourcepack;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3258;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_3518;
import net.minecraft.class_5352;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import net.minecraft.server.packs.*;
import org.jetbrains.annotations.NotNull;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.nio.file.*;
import java.util.*;
import java.util.function.Consumer;

@SuppressWarnings("ClassCanBeRecord")
public class RRPCacheRepoSource implements class_3285 {
    // Description: `%s (Remote cache)`
    private static final class_5352 PACK_SOURCE = class_5352.method_45281(
            packName -> class_2561.method_43469("pack.nameAndSource",
                    packName,
                    class_2561.method_43471("pack.source.mod.remoteresourcepack")
            ).method_27692(class_124.field_1080),
            /*loadedOnStart=*/true
    );

    private final Map<String, Path> knownCaches;

    public RRPCacheRepoSource(Map<String, Path> knownCaches) {
        this.knownCaches = Collections.unmodifiableMap(knownCaches);
    }

    private static final Gson GSON = new Gson();
    private static final String FORCE_COMPATIBLE = "remoteresourcepack:force_compatible";

    static byte[] modifyPackMcmeta(final byte @NotNull[] b) {
        Objects.requireNonNull(b, "input bytes shall be non-null");
        try {
            return modifyPackMcmetaImpl(b);
        } catch (Exception e) {
            RemoteResourcePack.LOGGER.warn("Exception while trying to modifying a pack.mcmeta. Remaining unchanged.", e);
            return b;
        }
    }

    private static byte[] modifyPackMcmetaImpl(final byte[] b) throws RuntimeException {
        String s = new String(b, StandardCharsets.UTF_8);
        JsonObject rootObj = GSON.fromJson(s, JsonObject.class);
        if (!class_3518.method_15258(rootObj, FORCE_COMPATIBLE, false)) {
            // no need to modify
            return b;
        }
        JsonObject packObj = class_3518.method_15296(rootObj, "pack");

        // 1.21.9+
        packObj.addProperty("min_format", 65);  // the version that defines min/max_format
        packObj.addProperty("max_format", Integer.MAX_VALUE);
        packObj.remove("supported_formats");
        packObj.remove("pack_format");
        return rootObj.toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void method_14453(@NotNull Consumer<class_3288> consumer) {
        for (Map.Entry<String, Path> entry : knownCaches.entrySet()) {
            String packId = RemoteResourcePack.packName(entry.getKey());
            Path zipFile = entry.getValue();
            // Now we don't support pack.mcmeta force-modification
            class_3288.class_7680 resourcesSupplier = new class_3258.class_8615(getZipFile(zipFile));
            class_3288 pack = class_3288.method_45275(
                    new class_9224(
                            packId,
                            class_2561.method_43471("pack.source.mod.remoteresourcepack")
                            .method_27693(" #")
                            .method_27693(packId.substring(19 /*prefix len*/, Math.min(packId.length(), 27))),
                            PACK_SOURCE,
                            Optional.empty()
                    ),
                    resourcesSupplier,
                    class_3264.field_14188,
                    new class_9225(false, class_3288.class_3289.field_14280, false)
            );
            Objects.requireNonNull(pack, () -> "Missing pack meta for " + packId);
            consumer.accept(pack);
        }
    }

    private static File getZipFile(Path zipFile) {
        try {
            return zipFile.toFile();
        } catch (UnsupportedOperationException e) {
            try {
                var file = File.createTempFile("RRPCache", ".zip");
                file.deleteOnExit();
                Files.copy(zipFile, file.toPath());
                return file;
            } catch (IOException ex) {
                throw new UncheckedIOException(
                        "File " + zipFile + " (in filesystem " + zipFile.getFileSystem() +
                                "), failed to copy to temp file",
                        ex
                );
            }
        }
    }
}
