/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.remoteresourcepack;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3258;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_3518;
import net.minecraft.class_5352;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.jetbrains.annotations.NotNull;
import xland.mcmod.remoteresourcepack.RemoteResourcePack;

public class RRPCacheRepoSource
implements class_3285 {
    private static final class_5352 PACK_SOURCE = class_5352.method_45281(packName -> class_2561.method_43469((String)"pack.nameAndSource", (Object[])new Object[]{packName, class_2561.method_43471((String)"pack.source.mod.remoteresourcepack")}).method_27692(class_124.field_1080), (boolean)true);
    private final Map<String, Path> knownCaches;
    private static final Gson GSON = new Gson();
    private static final String FORCE_COMPATIBLE = "remoteresourcepack:force_compatible";

    public RRPCacheRepoSource(Map<String, Path> knownCaches) {
        this.knownCaches = Collections.unmodifiableMap(knownCaches);
    }

    static byte[] modifyPackMcmeta(byte @NotNull [] b) {
        Objects.requireNonNull(b, "input bytes shall be non-null");
        try {
            return RRPCacheRepoSource.modifyPackMcmetaImpl(b);
        }
        catch (Exception e) {
            RemoteResourcePack.LOGGER.warn("Exception while trying to modifying a pack.mcmeta. Remaining unchanged.", (Throwable)e);
            return b;
        }
    }

    private static byte[] modifyPackMcmetaImpl(byte[] b) throws RuntimeException {
        String s = new String(b, StandardCharsets.UTF_8);
        JsonObject rootObj = (JsonObject)GSON.fromJson(s, JsonObject.class);
        if (!class_3518.method_15258((JsonObject)rootObj, (String)FORCE_COMPATIBLE, (boolean)false)) {
            return b;
        }
        JsonObject packObj = class_3518.method_15296((JsonObject)rootObj, (String)"pack");
        packObj.addProperty("min_format", (Number)65);
        packObj.addProperty("max_format", (Number)Integer.MAX_VALUE);
        packObj.remove("supported_formats");
        packObj.remove("pack_format");
        return rootObj.toString().getBytes(StandardCharsets.UTF_8);
    }

    public void method_14453(@NotNull Consumer<class_3288> consumer) {
        for (Map.Entry<String, Path> entry : this.knownCaches.entrySet()) {
            String packId = RemoteResourcePack.packName(entry.getKey());
            Path zipFile = entry.getValue();
            class_3258.class_8615 resourcesSupplier = new class_3258.class_8615(RRPCacheRepoSource.getZipFile(zipFile));
            class_3288 pack = class_3288.method_45275((class_9224)new class_9224(packId, (class_2561)class_2561.method_43471((String)"pack.source.mod.remoteresourcepack").method_27693(" #").method_27693(packId.substring(19, Math.min(packId.length(), 27))), PACK_SOURCE, Optional.empty()), (class_3288.class_7680)resourcesSupplier, (class_3264)class_3264.field_14188, (class_9225)new class_9225(false, class_3288.class_3289.field_14280, false));
            Objects.requireNonNull(pack, () -> "Missing pack meta for " + packId);
            consumer.accept(pack);
        }
    }

    private static File getZipFile(Path zipFile) {
        try {
            return zipFile.toFile();
        }
        catch (UnsupportedOperationException e) {
            try {
                File file = File.createTempFile("RRPCache", ".zip");
                file.deleteOnExit();
                Files.copy(zipFile, file.toPath(), new CopyOption[0]);
                return file;
            }
            catch (IOException ex) {
                throw new UncheckedIOException("File " + String.valueOf(zipFile) + " (in filesystem " + String.valueOf(zipFile.getFileSystem()) + "), failed to copy to temp file", ex);
            }
        }
    }
}

