/*
 * Decompiled with CFR 0.152.
 */
package de.exlll.configlib;

import de.exlll.configlib.NameFormatter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum NameFormatters implements NameFormatter
{
    IDENTITY{

        @Override
        public String format(String name) {
            return name;
        }
    }
    ,
    LOWER_UNDERSCORE{

        @Override
        public String format(String name) {
            StringBuilder builder = new StringBuilder(name.length());
            for (char c2 : name.toCharArray()) {
                if (Character.isUpperCase(c2)) {
                    char lower = Character.toLowerCase(c2);
                    builder.append('_').append(lower);
                    continue;
                }
                builder.append(c2);
            }
            return builder.toString();
        }
    }
    ,
    UPPER_UNDERSCORE{

        @Override
        public String format(String name) {
            StringBuilder builder = new StringBuilder(name.length());
            for (char c2 : name.toCharArray()) {
                if (Character.isLowerCase(c2)) {
                    builder.append(Character.toUpperCase(c2));
                    continue;
                }
                if (Character.isUpperCase(c2)) {
                    builder.append('_').append(c2);
                    continue;
                }
                builder.append(c2);
            }
            return builder.toString();
        }
    }
    ,
    LOWER_KEBAB_CASE{

        @Override
        public String format(String name) {
            StringBuilder builder = new StringBuilder(name.length());
            for (int i = 0; i < name.length(); ++i) {
                char c2 = name.charAt(i);
                if (Character.isUpperCase(c2)) {
                    builder.append('-');
                    builder.append(Character.toLowerCase(c2));
                    continue;
                }
                builder.append(c2);
            }
            return builder.toString();
        }
    }
    ,
    UPPER_KEBAB_CASE{

        @Override
        public String format(String name) {
            StringBuilder builder = new StringBuilder(name.length());
            for (int i = 0; i < name.length(); ++i) {
                char c2 = name.charAt(i);
                if (Character.isLowerCase(c2)) {
                    builder.append(Character.toUpperCase(c2));
                    continue;
                }
                if (Character.isUpperCase(c2)) {
                    builder.append('-');
                    builder.append(c2);
                    continue;
                }
                builder.append(c2);
            }
            return builder.toString();
        }
    };

}

