/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine;

import de.vectorflare.skyboxengine.SkyboxEngine;
import de.vectorflare.skyboxengine.config.ConfigManager;
import de.vectorflare.skyboxengine.config.Settings;
import de.vectorflare.skyboxengine.skybox.ActiveSkybox;
import de.vectorflare.skyboxengine.skybox.SkyboxReason;
import de.vectorflare.skyboxengine.tintcolor.TintProvider;
import java.util.Map;
import org.bukkit.entity.Player;

public class SkyboxAPI {
    public static SkyboxAPI getAPI() {
        return SkyboxEngine.api;
    }

    public void reload() {
        SkyboxEngine.getConfigManager().reload();
        SkyboxEngine.getPlayerSkyboxManager().recalculateSkyboxes();
    }

    public void reconstruct() {
        SkyboxEngine.getConfigManager().reload();
        SkyboxEngine.getPlayerSkyboxManager().recalculateSkyboxes();
    }

    public Map<String, Settings.SkyboxSettings> getRegisteredSkyboxes() {
        return SkyboxEngine.getConfigInstance().getSkyboxRegistry();
    }

    public Settings.SkyboxSettings getSkyboxSettings(String skyboxName) {
        return ConfigManager.getSkyboxSettings(skyboxName);
    }

    public Map<String, String> getDimensionSkyboxLinks() {
        return SkyboxEngine.getConfigInstance().getDimensionSkyboxes();
    }

    public Map<String, String> getBiomeSkyboxLinks() {
        return SkyboxEngine.getConfigInstance().getBiomeSkyboxes();
    }

    public void getSkyboxData(Player player) {
        SkyboxEngine.getPlayerSkyboxManager().getSkyboxData(player);
    }

    public void addSkyboxToPlayer(Player player, ActiveSkybox skybox) {
        SkyboxEngine.getPlayerSkyboxManager().getSkyboxData(player).addActivePlayerSkybox(skybox);
    }

    public void addSkyboxToPlayer(Player player, Settings.SkyboxSettings skybox) {
        SkyboxEngine.getPlayerSkyboxManager().getSkyboxData(player).addActivePlayerSkybox(new ActiveSkybox(skybox));
    }

    public void addSkyboxToPlayer(Player player, Settings.SkyboxSettings skybox, SkyboxReason reason) {
        SkyboxEngine.getPlayerSkyboxManager().getSkyboxData(player).addActivePlayerSkybox(new ActiveSkybox(skybox, reason));
    }

    public void addSkyboxToPlayer(Player player, Settings.SkyboxSettings skybox, int priority) {
        SkyboxEngine.getPlayerSkyboxManager().getSkyboxData(player).addActivePlayerSkybox(new ActiveSkybox(skybox, priority));
    }

    public void removeSkyboxFromPlayer(Player player, ActiveSkybox skybox) {
        SkyboxEngine.getPlayerSkyboxManager().getSkyboxData(player).removeActiveSkybox(skybox);
    }

    public void removeSkyboxFromPlayer(Player player, Settings.SkyboxSettings skybox) {
        SkyboxEngine.getPlayerSkyboxManager().getSkyboxData(player).removeActiveSkybox(new ActiveSkybox(skybox));
    }

    public void removeSkyboxFromPlayer(Player player, String skybox) {
        SkyboxEngine.getPlayerSkyboxManager().getSkyboxData(player).removeActiveSkybox(new ActiveSkybox(this.getSkyboxSettings(skybox)));
    }

    public void registerTintProvider(TintProvider tintProvider) {
        SkyboxEngine.getTintProviders().registerTintProvider(tintProvider);
    }
}

