/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine;

import com.github.retrooper.packetevents.PacketEvents;
import de.vectorflare.skyboxengine.SkyboxAPI;
import de.vectorflare.skyboxengine.commands.MainCommand;
import de.vectorflare.skyboxengine.config.ConfigManager;
import de.vectorflare.skyboxengine.config.Settings;
import de.vectorflare.skyboxengine.listener.BiomeSkyboxListener;
import de.vectorflare.skyboxengine.listener.MainListener;
import de.vectorflare.skyboxengine.listener.WorldSkyboxListener;
import de.vectorflare.skyboxengine.manager.PlayerSkyboxManager;
import de.vectorflare.skyboxengine.shaded.entitylib.APIConfig;
import de.vectorflare.skyboxengine.shaded.entitylib.EntityLib;
import de.vectorflare.skyboxengine.shaded.entitylib.spigot.SpigotEntityLibPlatform;
import de.vectorflare.skyboxengine.tintcolor.TintProviders;
import de.vectorflare.skyboxengine.tintcolor.premade.LowPrecisionTimeProvider;
import de.vectorflare.skyboxengine.tintcolor.premade.PlayerHeightProvider;
import de.vectorflare.skyboxengine.tintcolor.premade.TimeProvider;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIBukkitConfig;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SkyboxEngine
extends JavaPlugin {
    private static Logger logger;
    private static SkyboxEngine instance;
    private static ConfigManager configManager;
    private static Settings configInstance;
    private static PlayerSkyboxManager playerSkyboxManager;
    private static TintProviders tintProviders;
    static SkyboxAPI api;

    public void onLoad() {
        CommandAPIBukkitConfig commandAPIBukkitConfig = (CommandAPIBukkitConfig)new CommandAPIBukkitConfig(this).silentLogs(true);
        commandAPIBukkitConfig.skipReloadDatapacks(true);
        CommandAPI.onLoad(commandAPIBukkitConfig.verboseOutput(false));
    }

    public static void info(String message) {
        if (logger != null) {
            logger.info(message);
        }
    }

    public static void warning(String message) {
        if (logger != null) {
            logger.warning(message);
        }
    }

    public static void severe(String message) {
        if (logger != null) {
            logger.severe(message);
        }
    }

    public static void registerListener(Listener listener) {
        instance.getServer().getPluginManager().registerEvents(listener, (Plugin)instance);
    }

    public void onEnable() {
        logger = this.getLogger();
        instance = this;
        configManager = new ConfigManager(this);
        api = new SkyboxAPI();
        if (!this.loadConfig()) {
            instance.getServer().getPluginManager().disablePlugin((Plugin)instance);
            return;
        }
        CommandAPI.onEnable();
        SpigotEntityLibPlatform platform = new SpigotEntityLibPlatform(this);
        APIConfig settings = new APIConfig(PacketEvents.getAPI());
        EntityLib.init(platform, settings);
        playerSkyboxManager = new PlayerSkyboxManager();
        tintProviders = new TintProviders();
        SkyboxAPI.getAPI().registerTintProvider(new TimeProvider());
        SkyboxAPI.getAPI().registerTintProvider(new LowPrecisionTimeProvider());
        SkyboxAPI.getAPI().registerTintProvider(new PlayerHeightProvider());
        this.registerCommands();
        this.registerListeners();
    }

    public void onDisable() {
        this.getLogger().info("Disabling Skybox Engine");
        CommandAPI.onDisable();
    }

    private void registerCommands() {
        new MainCommand();
    }

    private void registerListeners() {
        SkyboxEngine.registerListener(new MainListener());
        SkyboxEngine.registerListener(new WorldSkyboxListener());
        SkyboxEngine.registerListener(new BiomeSkyboxListener());
    }

    private boolean loadConfig() {
        Optional<Throwable> error = configManager.loadConfig();
        if (error.isPresent()) {
            instance.getLogger().log(Level.SEVERE, "Failed to load configuration", error.get());
            return false;
        }
        configManager.reload();
        return true;
    }

    @Generated
    public static SkyboxEngine getInstance() {
        return instance;
    }

    @Generated
    public static ConfigManager getConfigManager() {
        return configManager;
    }

    @Generated
    public static Settings getConfigInstance() {
        return configInstance;
    }

    @Generated
    public static void setConfigInstance(Settings configInstance) {
        SkyboxEngine.configInstance = configInstance;
    }

    @Generated
    public static PlayerSkyboxManager getPlayerSkyboxManager() {
        return playerSkyboxManager;
    }

    @Generated
    public static TintProviders getTintProviders() {
        return tintProviders;
    }
}

