/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.commands;

import de.vectorflare.skyboxengine.SkyboxEngine;
import de.vectorflare.skyboxengine.config.ConfigManager;
import de.vectorflare.skyboxengine.config.Settings;
import de.vectorflare.skyboxengine.manager.PlayerSkyboxData;
import de.vectorflare.skyboxengine.skybox.ActiveSkybox;
import de.vectorflare.skyboxengine.skybox.SkyboxReason;
import de.vectorflare.skyboxengine.util.TextOutputUtil;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.GreedyStringArgument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.PlayerArgument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import java.util.Map;
import java.util.Objects;
import org.bukkit.entity.Player;

public class SkyboxCommands {
    public static String[] getActiveSkyboxes(Player player) {
        return (String[])SkyboxEngine.getPlayerSkyboxManager().getSkyboxData((Player)player).playerSkyboxes.stream().map(s -> SkyboxEngine.getConfigInstance().getSkyboxRegistry().entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), s.skybox)).map(Map.Entry::getKey).findFirst().orElse(null)).toArray(String[]::new);
    }

    public static String[] getRegisteredSkyboxes() {
        return (String[])SkyboxEngine.getConfigInstance().getSkyboxRegistry().keySet().toArray(String[]::new);
    }

    public static CommandAPICommand getInfoCommand() {
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("info").withArguments(new Argument[]{(Argument)new StringArgument("skybox").replaceSuggestions(ArgumentSuggestions.strings(SkyboxCommands.getRegisteredSkyboxes()))})).executes((commandSender, commandArguments) -> {
            String skybox = (String)commandArguments.getUnchecked("skybox");
            Settings.SkyboxSettings settings = ConfigManager.getSkyboxSettings(skybox);
            if (settings == null) {
                TextOutputUtil.sendMiniMessage(commandSender, true, "<red>Please specify a valid skybox");
            }
            TextOutputUtil.sendMiniMessage(commandSender, true, "<base>Showing Info for <accent>" + skybox);
            TextOutputUtil.sendMiniMessage(commandSender, false, "  <base>Shader Model: <accent>" + settings.getSkyboxId());
            if (settings.getTintProvider() != null && !settings.getTintProvider().isEmpty()) {
                TextOutputUtil.sendMiniMessage(commandSender, "  <base>Tint Provider: <accent>" + settings.getTintProvider());
            } else {
                TextOutputUtil.sendMiniMessage(commandSender, "  <base>Tint Provider: <accent>not specified");
            }
        }, new ExecutorType[0]);
    }

    public static CommandAPICommand getEnableCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("enable").withArguments(new Argument[]{new PlayerArgument("target")})).withArguments(new Argument[]{(Argument)new StringArgument("skybox").replaceSuggestions(ArgumentSuggestions.strings(SkyboxCommands.getRegisteredSkyboxes()))})).withOptionalArguments(new Argument[]{new IntegerArgument("priority")})).withOptionalArguments(new Argument[]{(Argument)((Argument)new GreedyStringArgument("forceCheck").withPermission("skyboxengine.command.force")).replaceSuggestions(ArgumentSuggestions.strings("force"))})).executes((commandSender, commandArguments) -> {
            Settings.SkyboxSettings settings;
            Player p = (Player)commandArguments.getUnchecked("target");
            String skybox = (String)commandArguments.getUnchecked("skybox");
            int priority = commandArguments.getOrDefaultUnchecked("priority", Integer.valueOf(SkyboxEngine.getConfigInstance().getCommandSkyboxPriority()));
            if (priority == -1) {
                priority = SkyboxEngine.getConfigInstance().getCommandSkyboxPriority();
            }
            if ((settings = ConfigManager.getSkyboxSettings(skybox)) == null) {
                TextOutputUtil.sendMiniMessage(commandSender, true, "<red>Please specify a valid skybox");
            }
            PlayerSkyboxData data = SkyboxEngine.getPlayerSkyboxManager().getSkyboxData(p);
            ActiveSkybox current = null;
            for (ActiveSkybox as : (ActiveSkybox[])data.playerSkyboxes.toArray(ActiveSkybox[]::new)) {
                if (!as.skybox.equals(settings)) continue;
                current = as;
            }
            boolean forceCheck = commandArguments.getOrDefaultUnchecked("forceCheck", "").equals("force");
            if (!forceCheck && current != null) {
                TextOutputUtil.sendMiniMessage(commandSender, true, "<red>Registering multiple instances of the same skybox on a player is not supported and may lead to visual artifacts. You can fix this by adding a new skybox configuration with the same settings as this one.");
                TextOutputUtil.sendMiniMessage(commandSender, "<red>If you wish to continue anyways, add 'force' to the end of the command <i>(You can enter a priority of -1 to continue without overriding the priority)</i>");
                return;
            }
            data.addActivePlayerSkybox(new ActiveSkybox(settings, SkyboxReason.COMMAND, priority));
            TextOutputUtil.sendMiniMessage(commandSender, true, "<base>Enabled Skybox <accent>" + skybox + "<base> for <accent> " + p.getName());
        }, new ExecutorType[0]);
    }

    public static CommandAPICommand getReplaceCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("replace").withArguments(new Argument[]{new PlayerArgument("target")})).withArguments(new Argument[]{(Argument)new StringArgument("skybox").replaceSuggestions(ArgumentSuggestions.strings(SkyboxCommands.getRegisteredSkyboxes()))})).withOptionalArguments(new Argument[]{new IntegerArgument("priority")})).withOptionalArguments(new Argument[]{(Argument)((Argument)new GreedyStringArgument("forceCheck").withPermission("skyboxengine.command.force")).replaceSuggestions(ArgumentSuggestions.strings("force"))})).executes((commandSender, commandArguments) -> {
            Settings.SkyboxSettings settings;
            Player p = (Player)commandArguments.getUnchecked("target");
            String skybox = (String)commandArguments.getUnchecked("skybox");
            int priority = commandArguments.getOrDefaultUnchecked("priority", Integer.valueOf(SkyboxEngine.getConfigInstance().getCommandSkyboxPriority()));
            if (priority == -1) {
                priority = SkyboxEngine.getConfigInstance().getCommandSkyboxPriority();
            }
            if ((settings = ConfigManager.getSkyboxSettings(skybox)) == null) {
                TextOutputUtil.sendMiniMessage(commandSender, true, "<red>Please specify a valid skybox");
            }
            PlayerSkyboxData data = SkyboxEngine.getPlayerSkyboxManager().getSkyboxData(p);
            for (ActiveSkybox as : (ActiveSkybox[])data.playerSkyboxes.toArray(ActiveSkybox[]::new)) {
                if (as.reason != SkyboxReason.COMMAND && as.reason != SkyboxReason.CUSTOM) continue;
                data.removeActiveSkybox(new ActiveSkybox(as.skybox, SkyboxReason.COMMAND, 1));
            }
            data.addActivePlayerSkybox(new ActiveSkybox(settings, SkyboxReason.COMMAND, priority));
            TextOutputUtil.sendMiniMessage(commandSender, true, "<base>Enabled Skybox <accent>" + skybox + "<base> for <accent> " + p.getName());
        }, new ExecutorType[0]);
    }

    public static CommandAPICommand getDisableCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("disable").withArguments(new Argument[]{new PlayerArgument("target")})).withArguments(new Argument[]{(Argument)new StringArgument("skybox").replaceSuggestions(ArgumentSuggestions.strings(info -> SkyboxCommands.getActiveSkyboxes((Player)info.previousArgs().getUnchecked("target"))))})).withOptionalArguments(new Argument[]{(Argument)((Argument)new GreedyStringArgument("forceCheck").withPermission("skyboxengine.command.force")).replaceSuggestions(ArgumentSuggestions.strings("force"))})).executes((commandSender, commandArguments) -> {
            Player p = (Player)commandArguments.getUnchecked("target");
            String skybox = (String)commandArguments.getUnchecked("skybox");
            Settings.SkyboxSettings settings = ConfigManager.getSkyboxSettings(skybox);
            if (settings == null) {
                TextOutputUtil.sendMiniMessage(commandSender, true, "<red>Please specify a valid skybox");
            }
            PlayerSkyboxData data = SkyboxEngine.getPlayerSkyboxManager().getSkyboxData(p);
            ActiveSkybox current = null;
            for (ActiveSkybox as : (ActiveSkybox[])data.playerSkyboxes.toArray(ActiveSkybox[]::new)) {
                if (!as.skybox.equals(settings)) continue;
                current = as;
            }
            if (current == null) {
                TextOutputUtil.sendMiniMessage(commandSender, true, "<red>Skybox isn't active on player");
                return;
            }
            boolean forceCheck = commandArguments.getOrDefaultUnchecked("forceCheck", "").equals("force");
            if (!(forceCheck || current.reason != SkyboxReason.BIOME && current.reason != SkyboxReason.DIMENSION)) {
                TextOutputUtil.sendMiniMessage(commandSender, true, "<red>This Skybox is registered internally, removing these manually is not supported and may lead to visual artifacts. Please add 'force' to the end of the command if you wish to continue anyways");
                return;
            }
            data.removeActiveSkybox(new ActiveSkybox(settings, SkyboxReason.COMMAND, 1));
            TextOutputUtil.sendMiniMessage(commandSender, true, "<base>Disabled Skybox <accent>" + skybox + "<base> for <accent> " + p.getName());
        }, new ExecutorType[0]);
    }
}

