/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.config;

import de.exlll.configlib.YamlConfigurationProperties;
import de.exlll.configlib.YamlConfigurations;
import de.vectorflare.skyboxengine.SkyboxEngine;
import de.vectorflare.skyboxengine.config.Settings;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class ConfigManager {
    private final SkyboxEngine plugin;
    private Settings settings;

    public ConfigManager(SkyboxEngine plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public Optional<Throwable> loadConfig() {
        YamlConfigurationProperties properties = ConfigManager.createConfigProperties();
        File settingsFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!settingsFile.exists()) {
            this.settings = new Settings();
            this.saveYamlConfiguration(settingsFile, this.settings);
            return Optional.empty();
        }
        try {
            this.settings = YamlConfigurations.update(settingsFile.toPath(), Settings.class, properties);
            SkyboxEngine.setConfigInstance(this.settings);
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of(e);
        }
    }

    public static YamlConfigurationProperties createConfigProperties() {
        return ((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)YamlConfigurationProperties.newBuilder().charset(StandardCharsets.UTF_8)).outputNulls(false)).inputNulls(false)).build();
    }

    public void reload() {
        this.settings = YamlConfigurations.load(new File(this.plugin.getDataFolder(), "config.yml").toPath(), Settings.class, ConfigManager.createConfigProperties());
        SkyboxEngine.setConfigInstance(this.settings);
        SkyboxEngine.info("Loaded " + this.settings.getSkyboxRegistry().size() + " registered skyboxes");
        SkyboxEngine.info("Loaded " + this.settings.getDimensionSkyboxes().size() + " dimension overrides");
        SkyboxEngine.info("Loaded " + this.settings.getBiomeSkyboxes().size() + " biome overrides");
    }

    public static Settings.SkyboxSettings getSkyboxSettings(String id) {
        if (!SkyboxEngine.getConfigInstance().getSkyboxRegistry().containsKey(id)) {
            return null;
        }
        return SkyboxEngine.getConfigInstance().getSkyboxRegistry().get(id);
    }

    public static Settings.SkyboxSettings getDefaultSkybox() {
        String defaultSkybox = SkyboxEngine.getConfigInstance().getDefaultSkybox();
        if (defaultSkybox == null) {
            return null;
        }
        if (SkyboxEngine.getConfigInstance().getDefaultSkybox().isBlank()) {
            return null;
        }
        return ConfigManager.getSkyboxSettings(defaultSkybox);
    }

    public <T> T loadYamlConfiguration(File file, Class<T> clazz) {
        return YamlConfigurations.load(file.toPath(), clazz, ConfigManager.createConfigProperties());
    }

    public <T> void saveYamlConfiguration(File file, T configuration) {
        YamlConfigurations.save(file.toPath(), configuration.getClass(), configuration, ConfigManager.createConfigProperties());
    }

    @Generated
    public SkyboxEngine getPlugin() {
        return this.plugin;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }
}

