/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.manager;

import de.vectorflare.skyboxengine.SkyboxEngine;
import de.vectorflare.skyboxengine.config.ConfigManager;
import de.vectorflare.skyboxengine.config.Settings;
import de.vectorflare.skyboxengine.skybox.ActiveSkybox;
import de.vectorflare.skyboxengine.skybox.PlayerSkybox;
import de.vectorflare.skyboxengine.skybox.SkyboxReason;
import java.util.PriorityQueue;
import org.bukkit.entity.Player;

public class PlayerSkyboxData {
    public final PriorityQueue<ActiveSkybox> playerSkyboxes;
    public Player player;
    public PlayerSkybox renderedPlayerSkybox;

    public PlayerSkyboxData(Player player) {
        this.player = player;
        this.playerSkyboxes = new PriorityQueue();
        if (SkyboxEngine.getConfigInstance().getDefaultSkybox() != null && !SkyboxEngine.getConfigInstance().getDefaultSkybox().isBlank()) {
            this.addDefaultSkybox();
        }
    }

    public void tick() {
        if (this.renderedPlayerSkybox != null) {
            this.renderedPlayerSkybox.tickSkybox();
        }
    }

    public void remove() {
        if (this.renderedPlayerSkybox != null) {
            this.renderedPlayerSkybox.removeSkybox();
        }
        this.playerSkyboxes.clear();
    }

    public void addActivePlayerSkybox(ActiveSkybox skybox) {
        this.playerSkyboxes.add(skybox);
        this.changeRenderedPlayerSkybox();
    }

    public void removeActiveSkybox(ActiveSkybox skybox) {
        this.playerSkyboxes.remove(skybox);
        this.changeRenderedPlayerSkybox();
    }

    public void removeSkybox(Settings.SkyboxSettings settings) {
        PriorityQueue<ActiveSkybox> duplicate = new PriorityQueue<ActiveSkybox>(this.playerSkyboxes);
        duplicate.forEach(skybox -> {
            if (skybox.skybox.equals(settings)) {
                this.playerSkyboxes.remove(skybox);
            }
        });
        this.changeRenderedPlayerSkybox();
    }

    public void clearActiveSkyboxes() {
        this.playerSkyboxes.clear();
        this.changeRenderedPlayerSkybox();
    }

    public void addDefaultSkybox() {
        for (ActiveSkybox activeSkybox : this.playerSkyboxes) {
            if (activeSkybox.reason != SkyboxReason.DEFAULT) continue;
            this.removeActiveSkybox(activeSkybox);
            break;
        }
        if (ConfigManager.getDefaultSkybox() == null) {
            return;
        }
        this.addActivePlayerSkybox(new ActiveSkybox(ConfigManager.getDefaultSkybox(), SkyboxReason.DEFAULT, 10000));
    }

    public void changeRenderedPlayerSkybox() {
        this.changeRenderedPlayerSkybox(false);
    }

    public void changeRenderedPlayerSkybox(boolean force) {
        ActiveSkybox skybox = this.playerSkyboxes.peek();
        if (skybox == null) {
            if (this.renderedPlayerSkybox != null) {
                this.renderedPlayerSkybox.removeSkybox(0);
                this.renderedPlayerSkybox = null;
            }
            return;
        }
        if (!force && this.renderedPlayerSkybox != null && skybox.skybox == this.renderedPlayerSkybox.getSettings()) {
            return;
        }
        if (this.renderedPlayerSkybox != null) {
            this.renderedPlayerSkybox.removeSkybox(1);
        }
        this.renderedPlayerSkybox = new PlayerSkybox(this.player, skybox.skybox);
        this.renderedPlayerSkybox.createSkybox();
    }
}

