/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.manager;

import de.vectorflare.skyboxengine.SkyboxEngine;
import de.vectorflare.skyboxengine.listener.BiomeSkyboxListener;
import de.vectorflare.skyboxengine.listener.WorldSkyboxListener;
import de.vectorflare.skyboxengine.manager.PlayerSkyboxData;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class PlayerSkyboxManager {
    private final HashMap<UUID, PlayerSkyboxData> playerSkyboxes = new HashMap();
    private final BukkitTask updateTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)SkyboxEngine.getInstance(), this::tickHandler, 0L, 1L);

    public PlayerSkyboxData getSkyboxData(Player player) {
        return this.playerSkyboxes.get(player.getUniqueId());
    }

    public void tickHandler() {
        this.playerSkyboxes.values().forEach(PlayerSkyboxData::tick);
    }

    public void addPlayer(Player player) {
        this.playerSkyboxes.put(player.getUniqueId(), new PlayerSkyboxData(player));
    }

    public void removePlayer(Player player) {
        this.playerSkyboxes.get(player.getUniqueId()).remove();
        this.playerSkyboxes.remove(player.getUniqueId());
    }

    public void recalculateSkyboxes() {
        BiomeSkyboxListener.retrackBiomes();
        BiomeSkyboxListener.checkBiomeChanges();
        WorldSkyboxListener.checkWorldChanges();
        for (PlayerSkyboxData data : this.playerSkyboxes.values()) {
            data.addDefaultSkybox();
        }
    }
}

