/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.common;

import com.github.retrooper.packetevents.PacketEventsAPI;
import de.vectorflare.skyboxengine.shaded.entitylib.APIConfig;
import de.vectorflare.skyboxengine.shaded.entitylib.EntityLibAPI;
import de.vectorflare.skyboxengine.shaded.entitylib.Platform;
import de.vectorflare.skyboxengine.shaded.entitylib.container.EntityContainer;
import de.vectorflare.skyboxengine.shaded.entitylib.tick.TickContainer;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.WrapperEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityLibAPI<P, T>
implements EntityLibAPI<T> {
    protected final Platform<P> platform;
    protected final PacketEventsAPI<?> packetEvents;
    protected final APIConfig settings;
    protected final Collection<TickContainer<?, T>> tickContainers;
    protected final EntityContainer defaultEntityContainer = EntityContainer.basic();

    protected AbstractEntityLibAPI(Platform<P> platform, APIConfig settings) {
        this.platform = platform;
        this.packetEvents = settings.getPacketEvents();
        this.settings = settings;
        this.tickContainers = settings.shouldTickTickables() ? new HashSet() : Collections.emptyList();
    }

    @Override
    @Nullable
    public WrapperEntity getEntity(int id) {
        return this.defaultEntityContainer.getEntity(id);
    }

    @Override
    @Nullable
    public WrapperEntity getEntity(@NotNull UUID uuid) {
        return this.defaultEntityContainer.getEntity(uuid);
    }

    @Override
    @NotNull
    public Collection<WrapperEntity> getAllEntities() {
        return this.defaultEntityContainer.getEntities();
    }

    @Override
    @NotNull
    public EntityContainer getDefaultContainer() {
        return this.defaultEntityContainer;
    }

    @Override
    @NotNull
    public APIConfig getSettings() {
        return this.settings;
    }

    @Override
    public PacketEventsAPI<?> getPacketEvents() {
        return this.packetEvents;
    }

    @Override
    @NotNull
    public Collection<TickContainer<?, T>> getTickContainers() {
        return this.tickContainers;
    }
}

