/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.common;

import de.vectorflare.skyboxengine.shaded.entitylib.APIConfig;
import de.vectorflare.skyboxengine.shaded.entitylib.EntityIdProvider;
import de.vectorflare.skyboxengine.shaded.entitylib.EntityUuidProvider;
import de.vectorflare.skyboxengine.shaded.entitylib.Platform;
import de.vectorflare.skyboxengine.shaded.entitylib.TrackedEntity;
import de.vectorflare.skyboxengine.shaded.entitylib.event.EventHandler;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPlatform<P>
implements Platform<P> {
    protected final P handle;
    protected Logger logger;
    private EventHandler eventHandler;
    private EntityIdProvider entityIdProvider;
    private EntityUuidProvider entityUuidProvider;

    public AbstractPlatform(P handle) {
        this.handle = handle;
        this.entityIdProvider = new EntityIdProvider.DefaultEntityIdProvider();
        this.entityUuidProvider = new EntityUuidProvider.DefaultEntityUuidProvider();
    }

    @Override
    @NotNull
    public Stream<TrackedEntity> queryPlatformEntities() {
        throw new UnsupportedOperationException("Platform does not support querying entities.");
    }

    @Override
    @Nullable
    public TrackedEntity findPlatformEntity(int entityId) {
        throw new UnsupportedOperationException("Platform does not support querying entities.");
    }

    @Override
    public void setupApi(@NotNull APIConfig settings) {
        this.eventHandler = EventHandler.create();
        this.entityIdProvider = new EntityIdProvider.DefaultEntityIdProvider();
        this.entityUuidProvider = new EntityUuidProvider.DefaultEntityUuidProvider();
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public EntityIdProvider getEntityIdProvider() {
        return this.entityIdProvider;
    }

    @Override
    @NotNull
    public EntityUuidProvider getEntityUuidProvider() {
        return this.entityUuidProvider;
    }

    @Override
    public void setEntityIdProvider(EntityIdProvider entityIdProvider) {
        this.entityIdProvider = entityIdProvider;
    }

    @Override
    public void setEntityUuidProvider(EntityUuidProvider entityUuidProvider) {
        this.entityUuidProvider = entityUuidProvider;
    }

    @Override
    @NotNull
    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    @NotNull
    public P getHandle() {
        return this.handle;
    }
}

