/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.event;

import de.vectorflare.skyboxengine.shaded.entitylib.event.CancellableEntityLibEvent;
import de.vectorflare.skyboxengine.shaded.entitylib.event.EntityLibEvent;
import de.vectorflare.skyboxengine.shaded.entitylib.event.EventCallback;
import de.vectorflare.skyboxengine.shaded.entitylib.event.EventHandlerImpl;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public interface EventHandler {
    @NotNull
    public static EventHandler create() {
        return new EventHandlerImpl();
    }

    @NotNull
    public Map<Class<? extends EntityLibEvent>, Collection<EventCallback>> getEventCallbacksMap();

    default public <E extends EntityLibEvent> boolean addEventCallback(@NotNull Class<E> eventClass, @NotNull EventCallback<E> eventCallback) {
        Collection<EventCallback> callbacks = this.getEventCallbacks(eventClass);
        return callbacks.add(eventCallback);
    }

    default public <E extends EntityLibEvent> boolean removeEventCallback(@NotNull Class<E> eventClass, @NotNull EventCallback<E> eventCallback) {
        Collection<EventCallback> callbacks = this.getEventCallbacks(eventClass);
        return callbacks.remove(eventCallback);
    }

    @NotNull
    default public <E extends EntityLibEvent> Collection<EventCallback> getEventCallbacks(@NotNull Class<E> eventClass) {
        return this.getEventCallbacksMap().computeIfAbsent(eventClass, clazz -> new CopyOnWriteArraySet());
    }

    @NotNull
    default public Stream<EventCallback> getEventCallbacks() {
        return this.getEventCallbacksMap().values().stream().flatMap(Collection::stream);
    }

    default public <E extends EntityLibEvent> void callEvent(@NotNull Class<E> eventClass, @NotNull E event) {
        Collection<EventCallback> eventCallbacks = this.getEventCallbacks(eventClass);
        this.runEvent(eventCallbacks, event);
    }

    default public <E extends EntityLibEvent & CancellableEntityLibEvent> void callCancellableEvent(@NotNull Class<E> eventClass, @NotNull E event, @NotNull Runnable successCallback) {
        this.callEvent(eventClass, event);
        if (!((CancellableEntityLibEvent)event).isCancelled()) {
            successCallback.run();
        }
    }

    default public <E extends EntityLibEvent> void runEvent(@NotNull Collection<EventCallback> eventCallbacks, @NotNull E event) {
        for (EventCallback eventCallback : eventCallbacks) {
            eventCallback.run(event);
        }
    }
}

