/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.event;

import de.vectorflare.skyboxengine.shaded.entitylib.event.EntityLibEvent;
import de.vectorflare.skyboxengine.shaded.entitylib.event.EventCallback;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public interface EventListener<E extends EntityLibEvent> {
    @NotNull
    public Class<E> getEventClass();

    public void handle(@NotNull E var1);

    public static <T extends EntityLibEvent> EventCallback<T> createEventCallback(@NotNull EventListener<T> listener) {
        return listener::handle;
    }

    public static <T extends EntityLibEvent> EventListener<T> generateListener(final Class<T> eventClass, final Consumer<T> consumer) {
        return new EventListener<T>(){

            @Override
            @NotNull
            public Class<T> getEventClass() {
                return eventClass;
            }

            @Override
            public void handle(@NotNull T event) {
                consumer.accept(event);
            }
        };
    }
}

