/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.extras;

import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.util.Vector3d;

public final class CoordinateUtil {
    private CoordinateUtil() {
    }

    public static Location withDirection(Location location, Vector3d direction) {
        double x = direction.getX();
        double z = direction.getZ();
        if (x == 0.0 && z == 0.0) {
            float pitch = direction.getY() > 0.0 ? -90.0f : 90.0f;
            return new Location(location.getX(), location.getY(), location.getZ(), location.getYaw(), pitch);
        }
        double theta = Math.atan2(-x, z);
        double xz = Math.sqrt(CoordinateUtil.square(x) + CoordinateUtil.square(z));
        double _2PI = Math.PI * 2;
        return new Location(location.getX(), location.getY(), location.getZ(), (float)Math.toDegrees((theta + Math.PI * 2) % (Math.PI * 2)), (float)Math.toDegrees(Math.atan(-direction.getY() / xz)));
    }

    public static double square(double in) {
        return in * in;
    }
}

