/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.extras.skin;

import com.github.retrooper.packetevents.protocol.player.TextureProperty;
import de.vectorflare.skyboxengine.shaded.entitylib.extras.MojangApiError;
import de.vectorflare.skyboxengine.shaded.entitylib.extras.skin.ErroredTextureProperties;
import de.vectorflare.skyboxengine.shaded.entitylib.extras.skin.SFUtils;
import de.vectorflare.skyboxengine.shaded.entitylib.extras.skin.SkinFetcher;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;

final class CachedSkinFetcherImpl
implements SkinFetcher {
    private final long cacheDuration;
    private final Consumer<MojangApiError> onErr;
    private final Map<String, CachedData> cache = new HashMap<String, CachedData>();
    private final Map<UUID, CachedData> cacheUUID = new HashMap<UUID, CachedData>();

    CachedSkinFetcherImpl(Consumer<MojangApiError> onErr, long cacheDuration) {
        this.onErr = onErr;
        this.cacheDuration = cacheDuration;
    }

    @Override
    public List<TextureProperty> getSkin(String playerName) {
        if (this.cache.containsKey(playerName)) {
            CachedData data = this.cache.get(playerName);
            if (data.expiration > System.currentTimeMillis()) {
                return data.skin;
            }
            this.cache.remove(playerName);
        }
        return this.putAndReturn(playerName);
    }

    @Override
    public List<TextureProperty> getSkin(UUID uuid) {
        if (this.cacheUUID.containsKey(uuid)) {
            CachedData data = this.cacheUUID.get(uuid);
            if (data.expiration > System.currentTimeMillis()) {
                return data.skin;
            }
            this.cacheUUID.remove(uuid);
        }
        return this.putAndReturn(uuid);
    }

    @Override
    public List<TextureProperty> getSkinOrDefault(String playerName, List<TextureProperty> defaults) {
        List<TextureProperty> skin;
        if (this.cache.containsKey(playerName)) {
            CachedData data = this.cache.get(playerName);
            if (data.expiration > System.currentTimeMillis()) {
                return data.skin;
            }
            this.cache.remove(playerName);
        }
        if ((skin = this.putAndReturn(playerName)).isEmpty()) {
            this.cache.remove(playerName);
            return defaults;
        }
        return skin;
    }

    @Override
    public List<TextureProperty> getSkinOrDefault(UUID uuid, List<TextureProperty> defaults) {
        List<TextureProperty> skin;
        if (this.cacheUUID.containsKey(uuid)) {
            CachedData data = this.cacheUUID.get(uuid);
            if (data.expiration > System.currentTimeMillis()) {
                return data.skin;
            }
            this.cacheUUID.remove(uuid);
        }
        if ((skin = this.putAndReturn(uuid)).isEmpty()) {
            this.cacheUUID.remove(uuid);
            return defaults;
        }
        return skin;
    }

    private List<TextureProperty> putAndReturn(String playerName) {
        ErroredTextureProperties p = SFUtils.getTextures(playerName);
        if (p.didError()) {
            if (this.onErr != null) {
                this.onErr.accept(new MojangApiError(p.getError()));
            }
            return Collections.emptyList();
        }
        List<TextureProperty> skin = p.getTextureProperties();
        CachedData data = this.cacheDuration == -1L ? new CachedData(skin, Long.MAX_VALUE) : new CachedData(skin, System.currentTimeMillis() + this.cacheDuration);
        this.cache.put(playerName, data);
        if (p.uuid != null) {
            this.cacheUUID.put(p.uuid, data);
        }
        return skin;
    }

    private List<TextureProperty> putAndReturn(UUID uuid) {
        ErroredTextureProperties p = SFUtils.getTextures(uuid);
        if (p.didError()) {
            if (this.onErr != null) {
                this.onErr.accept(new MojangApiError(p.getError()));
            }
            return Collections.emptyList();
        }
        List<TextureProperty> skin = p.getTextureProperties();
        if (this.cacheDuration != -1L) {
            this.cacheUUID.put(uuid, new CachedData(skin, System.currentTimeMillis() + this.cacheDuration));
        } else {
            this.cacheUUID.put(uuid, new CachedData(skin, Long.MAX_VALUE));
        }
        return skin;
    }

    static class CachedData {
        private final List<TextureProperty> skin;
        private final long expiration;

        CachedData(List<TextureProperty> skin, long expiration) {
            this.skin = skin;
            this.expiration = expiration;
        }
    }
}

