/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.extras.skin;

import com.github.retrooper.packetevents.protocol.player.TextureProperty;
import de.vectorflare.skyboxengine.shaded.entitylib.extras.MojangApiError;
import de.vectorflare.skyboxengine.shaded.entitylib.extras.skin.ErroredTextureProperties;
import de.vectorflare.skyboxengine.shaded.entitylib.extras.skin.SFUtils;
import de.vectorflare.skyboxengine.shaded.entitylib.extras.skin.SkinFetcher;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;

final class SkinFetcherImpl
implements SkinFetcher {
    private final Consumer<MojangApiError> rateLimitErrorConsumer;

    public SkinFetcherImpl(Consumer<MojangApiError> rateLimitErrorConsumer) {
        this.rateLimitErrorConsumer = rateLimitErrorConsumer;
    }

    @Override
    public List<TextureProperty> getSkin(String playerName) {
        ErroredTextureProperties p = SFUtils.getTextures(playerName);
        if (p.didError()) {
            this.rateLimitErrorConsumer.accept(p.getError());
            return Collections.emptyList();
        }
        return p.getTextureProperties();
    }

    @Override
    public List<TextureProperty> getSkin(UUID uuid) {
        ErroredTextureProperties p = SFUtils.getTextures(uuid);
        if (p.didError()) {
            this.rateLimitErrorConsumer.accept(p.getError());
            return Collections.emptyList();
        }
        return p.getTextureProperties();
    }

    @Override
    public List<TextureProperty> getSkinOrDefault(String playerName, List<TextureProperty> defaults) {
        ErroredTextureProperties p = SFUtils.getTextures(playerName);
        if (p.didError()) {
            this.rateLimitErrorConsumer.accept(p.getError());
            return defaults;
        }
        return p.getTextureProperties();
    }

    @Override
    public List<TextureProperty> getSkinOrDefault(UUID uuid, List<TextureProperty> defaults) {
        ErroredTextureProperties p = SFUtils.getTextures(uuid);
        if (p.didError()) {
            this.rateLimitErrorConsumer.accept(p.getError());
            return defaults;
        }
        return p.getTextureProperties();
    }
}

