/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.meta;

import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataType;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import de.vectorflare.skyboxengine.shaded.entitylib.EntityLib;
import de.vectorflare.skyboxengine.shaded.entitylib.EntityLibAPI;
import de.vectorflare.skyboxengine.shaded.entitylib.wrapper.WrapperEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Metadata {
    private final int entityId;
    private volatile boolean notifyAboutChanges = true;
    private final Map<Byte, EntityData> notNotifiedChanges = new HashMap<Byte, EntityData>();
    private final Map<Byte, EntityData> metadataMap = new ConcurrentHashMap<Byte, EntityData>();

    public Metadata(int entityId) {
        this.entityId = entityId;
    }

    public <T> T getIndex(byte index, @Nullable T defaultValue) {
        EntityData value = this.metadataMap.get(index);
        return (T)(value != null ? value.getValue() : defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setIndex(byte index, @NotNull EntityDataType<T> dataType, T value) {
        EntityData entry = new EntityData((int)index, dataType, value);
        this.metadataMap.put(index, entry);
        Optional<EntityLibAPI<?>> optionalApi = EntityLib.getOptionalApi();
        if (!optionalApi.isPresent()) {
            return;
        }
        WrapperEntity entity = optionalApi.get().getEntity(this.entityId);
        if (entity == null || !entity.isSpawned()) {
            return;
        }
        if (!this.notifyAboutChanges) {
            Map<Byte, EntityData> map = this.notNotifiedChanges;
            synchronized (map) {
                this.notNotifiedChanges.put(index, entry);
            }
        } else {
            entity.sendPacketToViewers((PacketWrapper<?>)this.createPacket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyAboutChanges(boolean notifyAboutChanges) {
        if (this.notifyAboutChanges == notifyAboutChanges) {
            return;
        }
        ArrayList<EntityData> entries = null;
        Map<Byte, EntityData> map = this.notNotifiedChanges;
        synchronized (map) {
            this.notifyAboutChanges = notifyAboutChanges;
            if (notifyAboutChanges) {
                entries = new ArrayList<EntityData>(this.notNotifiedChanges.values());
                if (entries.isEmpty()) {
                    return;
                }
                this.notNotifiedChanges.clear();
            }
        }
        WrapperEntity entity = EntityLib.getApi().getEntity(this.entityId);
        if (entries == null || entity == null || !entity.isSpawned()) {
            return;
        }
        WrapperPlayServerEntityMetadata packet = new WrapperPlayServerEntityMetadata(this.entityId, entries);
        entity.sendPacketsToViewers(new PacketWrapper[]{packet});
    }

    public void setMetaFromPacket(WrapperPlayServerEntityMetadata wrapper) {
        for (EntityData data : wrapper.getEntityMetadata()) {
            this.metadataMap.put((byte)data.getIndex(), data);
        }
    }

    public boolean isNotifyingChanges() {
        return this.notifyAboutChanges;
    }

    @NotNull
    List<EntityData> getEntries() {
        return Collections.unmodifiableList(new ArrayList<EntityData>(this.metadataMap.values()));
    }

    public WrapperPlayServerEntityMetadata createPacket() {
        return new WrapperPlayServerEntityMetadata(this.entityId, this.getEntries());
    }
}

