/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.meta.display;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.manager.server.VersionComparison;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.util.Quaternion4f;
import com.github.retrooper.packetevents.util.Vector3f;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.EntityMeta;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.Metadata;

public abstract class AbstractDisplayMeta
extends EntityMeta {
    public static final byte OFFSET = 8;
    public static final byte MAX_OFFSET = AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.NEWER_THAN_OR_EQUALS) ? (byte)23 : (byte)22;

    public AbstractDisplayMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
        AbstractDisplayMeta.isVersionNewer(ServerVersion.V_1_19_3);
    }

    public int getInterpolationDelay() {
        return this.metadata.getIndex((byte)8, 0);
    }

    public void setInterpolationDelay(int value) {
        this.metadata.setIndex((byte)8, EntityDataTypes.INT, value);
    }

    public int getTransformationInterpolationDuration() {
        return this.metadata.getIndex(AbstractDisplayMeta.offset((byte)8, 1), 0);
    }

    public void setTransformationInterpolationDuration(int value) {
        this.metadata.setIndex(AbstractDisplayMeta.offset((byte)8, 1), EntityDataTypes.INT, value);
    }

    public int getPositionRotationInterpolationDuration() {
        return this.metadata.getIndex(AbstractDisplayMeta.offset((byte)8, 2), 0);
    }

    public void setPositionRotationInterpolationDuration(int value) {
        this.metadata.setIndex(AbstractDisplayMeta.offset((byte)8, 2), EntityDataTypes.INT, value);
    }

    public Vector3f getTranslation() {
        byte offset = AbstractDisplayMeta.offset((byte)8, 3);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 2);
        }
        return this.metadata.getIndex(offset, Vector3f.zero());
    }

    public void setTranslation(Vector3f value) {
        byte offset = AbstractDisplayMeta.offset((byte)8, 3);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 2);
        }
        this.metadata.setIndex(offset, EntityDataTypes.VECTOR3F, value);
    }

    public Vector3f getScale() {
        byte offset = AbstractDisplayMeta.offset((byte)8, 4);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 3);
        }
        return this.metadata.getIndex(offset, new Vector3f(1.0f, 1.0f, 1.0f));
    }

    public void setScale(Vector3f value) {
        byte offset = AbstractDisplayMeta.offset((byte)8, 4);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 3);
        }
        this.metadata.setIndex(offset, EntityDataTypes.VECTOR3F, value);
    }

    public Quaternion4f getLeftRotation() {
        byte offset = AbstractDisplayMeta.offset((byte)8, 5);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 4);
        }
        return this.metadata.getIndex(offset, new Quaternion4f(0.0f, 0.0f, 0.0f, 1.0f));
    }

    public void setLeftRotation(Quaternion4f value) {
        byte offset = AbstractDisplayMeta.offset((byte)8, 5);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 4);
        }
        this.metadata.setIndex(offset, EntityDataTypes.QUATERNION, value);
    }

    public Quaternion4f getRightRotation() {
        byte offset = AbstractDisplayMeta.offset((byte)8, 6);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 5);
        }
        return this.metadata.getIndex(offset, new Quaternion4f(0.0f, 0.0f, 0.0f, 1.0f));
    }

    public void setRightRotation(Quaternion4f value) {
        byte offset = AbstractDisplayMeta.offset((byte)8, 6);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 5);
        }
        this.metadata.setIndex(offset, EntityDataTypes.QUATERNION, value);
    }

    public BillboardConstraints getBillboardConstraints() {
        byte offset = AbstractDisplayMeta.offset((byte)8, 7);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 6);
        }
        return BillboardConstraints.VALUES[this.metadata.getIndex(offset, (byte)0)];
    }

    public void setBillboardConstraints(BillboardConstraints value) {
        byte offset = AbstractDisplayMeta.offset((byte)8, 7);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 6);
        }
        this.metadata.setIndex(offset, EntityDataTypes.BYTE, (byte)value.ordinal());
    }

    public int getBrightnessOverride() {
        byte offset = AbstractDisplayMeta.offset((byte)8, 8);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 7);
        }
        return this.metadata.getIndex(offset, -1);
    }

    public void setBrightnessOverride(int value) {
        byte offset = AbstractDisplayMeta.offset((byte)8, 8);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 7);
        }
        this.metadata.setIndex(offset, EntityDataTypes.INT, value);
    }

    public float getViewRange() {
        byte offset = AbstractDisplayMeta.offset((byte)8, 9);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 8);
        }
        return this.metadata.getIndex(offset, Float.valueOf(1.0f)).floatValue();
    }

    public void setViewRange(float value) {
        byte offset = AbstractDisplayMeta.offset((byte)8, 9);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 8);
        }
        this.metadata.setIndex(offset, EntityDataTypes.FLOAT, Float.valueOf(value));
    }

    public float getShadowRadius() {
        byte offset = AbstractDisplayMeta.offset((byte)8, 10);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 9);
        }
        return this.metadata.getIndex(offset, Float.valueOf(0.0f)).floatValue();
    }

    public void setShadowRadius(float value) {
        byte offset = AbstractDisplayMeta.offset((byte)8, 10);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 9);
        }
        this.metadata.setIndex(offset, EntityDataTypes.FLOAT, Float.valueOf(value));
    }

    public float getShadowStrength() {
        byte offset = AbstractDisplayMeta.offset((byte)8, 11);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 10);
        }
        return this.metadata.getIndex(offset, Float.valueOf(1.0f)).floatValue();
    }

    public void setShadowStrength(float value) {
        byte offset = AbstractDisplayMeta.offset((byte)8, 11);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 10);
        }
        this.metadata.setIndex(offset, EntityDataTypes.FLOAT, Float.valueOf(value));
    }

    public float getWidth() {
        byte offset = AbstractDisplayMeta.offset((byte)8, 12);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 11);
        }
        return this.metadata.getIndex(offset, Float.valueOf(0.0f)).floatValue();
    }

    public void setWidth(float value) {
        byte offset = AbstractDisplayMeta.offset((byte)8, 12);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 11);
        }
        this.metadata.setIndex(offset, EntityDataTypes.FLOAT, Float.valueOf(value));
    }

    public float getHeight() {
        byte offset = AbstractDisplayMeta.offset((byte)8, 13);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 12);
        }
        return this.metadata.getIndex(offset, Float.valueOf(0.0f)).floatValue();
    }

    public void setHeight(float value) {
        byte offset = AbstractDisplayMeta.offset((byte)8, 13);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 12);
        }
        this.metadata.setIndex(offset, EntityDataTypes.FLOAT, Float.valueOf(value));
    }

    public int getGlowColorOverride() {
        byte offset = AbstractDisplayMeta.offset((byte)8, 14);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 13);
        }
        return this.metadata.getIndex(offset, -1);
    }

    public void setGlowColorOverride(int value) {
        byte offset = AbstractDisplayMeta.offset((byte)8, 14);
        if (AbstractDisplayMeta.isVersion(ServerVersion.V_1_20_2, VersionComparison.OLDER_THAN)) {
            offset = AbstractDisplayMeta.offset((byte)8, 13);
        }
        this.metadata.setIndex(offset, EntityDataTypes.INT, value);
    }

    public static enum BillboardConstraints {
        FIXED,
        VERTICAL,
        HORIZONTAL,
        CENTER;

        private static final BillboardConstraints[] VALUES;

        static {
            VALUES = BillboardConstraints.values();
        }
    }
}

