/*
 * Decompiled with CFR 0.152.
 */
package de.vectorflare.skyboxengine.shaded.entitylib.meta.mobs;

import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.Metadata;
import de.vectorflare.skyboxengine.shaded.entitylib.meta.types.AgeableMeta;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class FrogMeta
extends AgeableMeta {
    public static final byte OFFSET = 17;
    public static final byte MAX_OFFSET = 19;

    public FrogMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
    }

    @NotNull
    public Variant getVariant() {
        return this.metadata.getIndex((byte)17, Variant.TEMPERATE);
    }

    public void setVariant(@NotNull Variant value) {
        this.metadata.setIndex((byte)17, EntityDataTypes.FROG_VARIANT, value.ordinal());
    }

    public Optional<Integer> getTongueTarget() {
        return this.metadata.getIndex(FrogMeta.offset((byte)17, 1), Optional.empty());
    }

    public void setTongueTarget(int value) {
        this.metadata.setIndex(FrogMeta.offset((byte)17, 1), EntityDataTypes.OPTIONAL_INT, Optional.of(value));
    }

    public static enum Variant {
        TEMPERATE,
        WARM,
        COLD;

        private static final Variant[] VALUES;

        static {
            VALUES = Variant.values();
        }
    }
}

